/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import org.eclipse.jface.resource.FontDescriptor;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.AbstractLabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class ChartItemLabelDecorationRule
implements LabelDecorationRule {
    public static final ChartItemLabelDecorationRule INSTANCE = new ChartItemLabelDecorationRule();
    private static HiddenLabelDecorator HIDDEN_DECORATOR = new HiddenLabelDecorator();

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource item = (Resource)content;
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        Boolean hidden = (Boolean)graph.getPossibleRelatedValue(item, CHART.Chart_Item_hidden, (Binding)Bindings.BOOLEAN);
        if (hidden == null || !hidden.booleanValue()) {
            return null;
        }
        return HIDDEN_DECORATOR;
    }

    private static class HiddenLabelDecorator
    extends AbstractLabelDecorator {
        private HiddenLabelDecorator() {
        }

        public <F> F decorateFont(F font, String column, int itemIndex) {
            return (F)((FontDescriptor)font).withStyle(2);
        }

        public String decorateLabel(String label, String column, int itemIndex) {
            return String.valueOf(label) + " (hidden)";
        }
    }
}

