/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.browsing.ui.graph.impl.LazyViewpoint;
import org.simantics.browsing.ui.graph.impl.PropertyArray;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class MultiInputPropertyViewpointFactory
implements ViewpointFactory {
    public Viewpoint create(PrimitiveQueryUpdater provider, NodeContext context, BuiltinKeys.ViewpointKey key) {
        assert (provider != null);
        assert (context != null);
        return new LazyViewpoint(provider, context, key){

            @Override
            public NodeContext[] children(ReadGraph graph) throws DatabaseException {
                Resource[] rs = (Resource[])this.context.getConstant(BuiltinKeys.INPUT);
                if (rs.length == 0) {
                    return new NodeContext[0];
                }
                if (rs.length == 1) {
                    return new NodeContext[0];
                }
                Resource r = rs[0];
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                Resource type = graph.getSingleType(r, l0.Entity);
                int i = 1;
                while (i < rs.length) {
                    Resource type2 = graph.getSingleType(rs[i], l0.Entity);
                    if (!type.equals(type2)) {
                        return new NodeContext[0];
                    }
                    ++i;
                }
                Collection children = graph.getStatements(r, l0.HasProperty);
                ArrayList<NodeContext> resultContexts = new ArrayList<NodeContext>();
                for (Statement child : children) {
                    ArrayList<Resource> objects = new ArrayList<Resource>();
                    objects.add(child.getObject());
                    boolean ok = true;
                    int i2 = 1;
                    while (i2 < rs.length) {
                        Collection objects2 = graph.getObjects(rs[1], child.getPredicate());
                        if (objects2.size() != 1) {
                            ok = false;
                            break;
                        }
                        objects.add((Resource)objects2.iterator().next());
                        ++i2;
                    }
                    if (!ok) continue;
                    resultContexts.add(NodeContextBuilder.buildWithInput((Object)new PropertyArray(child.getPredicate(), objects)));
                }
                return resultContexts.toArray(new NodeContext[resultContexts.size()]);
            }

            @Override
            public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
                return this.children(graph).length > 0;
            }
        };
    }

    public String toString() {
        return "Properties";
    }
}

