/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TGProgressMonitor;
import org.simantics.db.layer0.util.TGTransferableGraphSource;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.ImportResult;
import org.simantics.graph.db.StreamingTransferableGraphFileReader;
import org.simantics.graph.db.TGStatusMonitor;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.db.WrapperAdvisor;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphFileReader;
import org.simantics.layer0.Layer0;
import org.simantics.utils.logging.TimeLogger;

public class MigrationStateImpl
implements MigrationState {
    private final HashMap<String, Object> properties = new HashMap();

    @Override
    public <T> T probeProperty(String key) throws DatabaseException {
        return (T)this.properties.get(key);
    }

    @Override
    public <T> T getProperty(String key) throws DatabaseException {
        Object property = this.properties.get(key);
        if (property != null) {
            return (T)property;
        }
        if ("baseURI".equals(key)) {
            throw new IllegalStateException("Base URI needs to be supplied for migration.");
        }
        if ("session".equals(key)) {
            throw new IllegalStateException("Session needs to be supplied for migration.");
        }
        if ("modelFile".equals(key)) {
            throw new IllegalStateException("Model file needs to be supplied for migration.");
        }
        if ("currentTG".equals(key)) {
            Resource resource = (Resource)this.probeProperty("currentResource");
            final Collection roots = (Collection)this.probeProperty("currentRootResources");
            if (roots != null) {
                Session session = (Session)this.getProperty("session");
                TransferableGraph1 tg = (TransferableGraph1)session.syncRequest((Read)new Read<TransferableGraph1>(){

                    public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
                        TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2(graph, roots, true, false);
                        TransferableGraphSource source = (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));
                        return TransferableGraphs.create((ReadGraph)graph, (TransferableGraphSource)source);
                    }
                });
                if (resource != null) {
                    MigrationUtils.clearTempResource(session, resource);
                }
                this.setProperty("currentResource", null);
                this.setProperty("currentRootResources", null);
                this.setProperty("revisionAfterTgImport", null);
                this.setProperty("currentTG", tg);
                return (T)tg;
            }
            try {
                File modelFile = (File)this.getProperty("modelFile");
                TimeLogger.log(MigrationStateImpl.class, (String)("reading TG into memory from " + modelFile));
                TransferableGraph1 tg = TransferableGraphFileReader.read((File)modelFile, (boolean)false);
                TimeLogger.log(MigrationStateImpl.class, (String)("read TG into memory from " + modelFile));
                this.setProperty("currentTG", tg);
                return (T)tg;
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        if ("currentTGS".equals(key)) {
            File modelFile = (File)this.getProperty("modelFile");
            return (T)this.initializeTransferableGraphSource(modelFile);
        }
        if ("currentDataContainer".equals(key)) {
            try {
                TransferableGraphSource tgs = (TransferableGraphSource)this.getProperty("currentTGS");
                DataContainer dc = tgs.getHeader();
                this.setProperty("currentDataContainer", dc);
                return (T)dc;
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        if ("tgExtensions".equals(key)) {
            try {
                TransferableGraphSource tgs = (TransferableGraphSource)this.getProperty("currentTGS");
                TreeMap extensions = tgs.getExtensions();
                this.setProperty("tgExtensions", extensions);
                return (T)extensions;
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        if ("currentResource".equals(key) || "currentRootResources".equals(key)) {
            TransferableGraphSource tgs;
            Session session = (Session)this.getProperty("session");
            IProgressMonitor monitor = (IProgressMonitor)this.probeProperty("progressMonitor");
            boolean updateDependencies = MigrationUtils.getProperty(this, "updateDependencies", Boolean.TRUE);
            File temporaryTg = this.exportCurrentTgAsTemporaryFile(session, monitor);
            if (temporaryTg != null) {
                this.setProperty("currentTGS", this.initializeTransferableGraphSource(temporaryTg));
            }
            if ((tgs = (TransferableGraphSource)this.getProperty("currentTGS")) != null) {
                this.importTransferableGraphSource(monitor, session, updateDependencies, tgs);
                if (temporaryTg != null) {
                    temporaryTg.delete();
                }
                return this.getProperty(key);
            }
        } else if ("updateDependencies".equals(key)) {
            return null;
        }
        return null;
    }

    @Override
    public <T> void setProperty(String key, T value) {
        this.properties.put(key, value);
    }

    public void dispose() {
        try {
            StreamingTransferableGraphFileReader tgs = (StreamingTransferableGraphFileReader)this.probeProperty("currentTGSReader");
            MigrationStateImpl.uncheckedClose((Closeable)tgs);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    private static void uncheckedClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }

    private Resource createTemporaryRoot(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource project = SimanticsInternal.getProject();
        Resource root = graph.getPossibleObject(project, L0.PartOf);
        Resource temp = Layer0Utils.getPossibleChild((ReadGraph)graph, root, "Temp");
        if (temp == null) {
            throw new AssumptionException("Temporary folder 'Temp' not found under " + graph.getPossibleURI(root));
        }
        Resource indexRoot = graph.newResource();
        String indexRootName = DateFormat.getDateTimeInstance(0, 0).format(new Date());
        indexRootName = NameUtils.findFreshName((ReadGraph)graph, (String)indexRootName, (Resource)temp, (Resource)L0.ConsistsOf, (String)"%s-%d");
        graph.claim(indexRoot, L0.InstanceOf, L0.IndexRoot);
        graph.addLiteral(indexRoot, L0.HasName, L0.String, (Object)indexRootName, (Binding)Bindings.STRING);
        graph.claim(temp, L0.ConsistsOf, indexRoot);
        return indexRoot;
    }

    private File exportCurrentTgAsTemporaryFile(Session session, IProgressMonitor monitor) throws DatabaseException {
        TransferableGraph1 tg = (TransferableGraph1)this.probeProperty("currentTG");
        if (tg == null) {
            return null;
        }
        try {
            File modelFile = (File)this.getProperty("modelFile");
            File tempFile = File.createTempFile("temporary-tgs", ".tg", SimanticsInternal.getTemporaryDirectory());
            TimeLogger.log(MigrationStateImpl.class, (String)("export temporary TG " + tempFile));
            DataContainer dc = DataContainers.readHeader((File)modelFile);
            TransferableGraphs.writeTransferableGraph((RequestProcessor)session, (String)dc.format, (int)dc.version, (TreeMap)dc.metadata, (TransferableGraphSource)new TGTransferableGraphSource(tg), (File)tempFile, (TGStatusMonitor)new TGExportMonitor(monitor, "Exporting temporary transferable graph"));
            this.setProperty("currentTG", null);
            TimeLogger.log(MigrationStateImpl.class, (String)("export temporary TG done " + tempFile));
            return tempFile;
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private TransferableGraphSource initializeTransferableGraphSource(File dataContainer) throws DatabaseException {
        try {
            StreamingTransferableGraphFileReader reader = new StreamingTransferableGraphFileReader(dataContainer);
            TransferableGraphSource tgs = reader.readTG();
            this.setProperty("currentTGSReader", reader);
            this.setProperty("currentTGS", tgs);
            return tgs;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DatabaseException("An I/O exception occurred during reading '" + dataContainer.getAbsolutePath() + "'", (Throwable)e);
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
    }

    private void importTransferableGraphSource(IProgressMonitor monitor, final Session session, final boolean updateDependencies, TransferableGraphSource tgs) throws DatabaseException {
        TimeLogger.log(MigrationStateImpl.class, (String)("import TGS " + tgs));
        final Resource indexRoot = (Resource)session.syncRequest((WriteResult)new WriteResultRequest<Resource>(){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                if (!updateDependencies) {
                    Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, true);
                }
                return MigrationStateImpl.this.createTemporaryRoot(graph);
            }
        });
        IImportAdvisor baseAdvisor = (IImportAdvisor)MigrationUtils.getProperty(this, "importAdvisor", new DefaultPasteImportAdvisor(indexRoot));
        WrapperAdvisor advisor = new WrapperAdvisor(baseAdvisor){

            public Resource getTarget() {
                return indexRoot;
            }

            public void beforeWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
                super.beforeWrite(graph, process);
                if (!updateDependencies) {
                    Layer0Utils.setDependenciesIndexingDisabled(graph, true);
                }
            }

            public void afterWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
                super.afterWrite(graph, process);
                Boolean storeResources = (Boolean)MigrationStateImpl.this.probeProperty("getResourceIds");
                if (storeResources != null && storeResources.booleanValue()) {
                    long[] ids = process.getResourceIds((SerialisationSupport)session.getService(SerialisationSupport.class));
                    MigrationStateImpl.this.setProperty("resourceIds", ids);
                }
            }
        };
        advisor.redirect(indexRoot);
        String task = "Importing model into database";
        monitor.subTask(task);
        ImportResult ir = TransferableGraphs.importGraph1((Session)session, (TransferableGraphSource)tgs, (IImportAdvisor)advisor, (TGStatusMonitor)new TGImportMonitor(monitor, task));
        monitor.subTask("");
        this.setProperty("importResult", ir);
        this.setProperty("currentResource", indexRoot);
        this.setProperty("currentRootResources", new ArrayList(advisor.getRoots()));
        this.setProperty("revisionAfterTgImport", ((ManagementSupport)session.getService(ManagementSupport.class)).getHeadRevisionId());
        TimeLogger.log(MigrationStateImpl.class, (String)("imported TGS " + tgs));
    }

    static class TGExportMonitor
    extends TGProgressMonitor {
        private final String message;

        public TGExportMonitor(IProgressMonitor monitor, String message) {
            super(monitor);
            this.message = message;
        }

        @Override
        protected void workDone(int percentage) {
            this.monitor.subTask(String.valueOf(this.message) + " (" + percentage + "%)");
        }
    }

    static class TGImportMonitor
    implements TGStatusMonitor {
        private final IProgressMonitor monitor;
        private final String message;

        public TGImportMonitor(IProgressMonitor monitor, String message) {
            this.monitor = monitor;
            this.message = message;
        }

        public void status(int percentage) {
            this.monitor.subTask(String.valueOf(this.message) + " (" + percentage + "%)");
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }
    }
}

