/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.utils.logging.TimeLogger;

public class MigrationSequence
implements MigrationStep {
    final List<MigrationStep> steps = new ArrayList<MigrationStep>();

    public MigrationSequence(ReadGraph graph, Resource sequence) throws DatabaseException {
        for (Resource step : ListUtils.toList((ReadGraph)graph, (Resource)sequence)) {
            MigrationStep ms = (MigrationStep)graph.adapt(step, MigrationStep.class);
            this.steps.add(ms);
        }
    }

    @Override
    public void applyTo(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        TimeLogger.resetTimeAndLog(this.getClass(), (String)"Running migration sequence");
        for (MigrationStep step : this.steps) {
            if (monitor.isCanceled()) {
                return;
            }
            TimeLogger.log(this.getClass(), (String)("Running migration step: " + step.getClass() + " (" + step + ")"));
            step.applyTo(monitor, session, state);
            if (monitor.isCanceled()) {
                TimeLogger.log(this.getClass(), (String)("Migration cancelled during step: " + step.getClass() + " (" + step + ")"));
                return;
            }
            monitor.subTask("");
            TimeLogger.log(this.getClass(), (String)("Completed migration step: " + step.getClass() + " (" + step + ")"));
        }
    }
}

