/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.commands.internal.serialization;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommandMetadata;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.commands.internal.serialization.CommandSerializer;
import org.simantics.scl.runtime.function.Function2;

public class CommandSerializerImpl
implements CommandSerializer {
    String name;
    Function2<Resource, Object, String>[] stringConverters;

    CommandSerializerImpl(String name, Function2<Resource, Object, String>[] stringConverters) {
        this.name = name;
        this.stringConverters = stringConverters;
    }

    @Override
    public void serialize(WriteGraph graph, Resource context, Object[] parameters) throws DatabaseException {
        if (parameters.length != this.stringConverters.length) {
            throw new IllegalArgumentException("Wrong number of parameters " + parameters.length + " given. Expected " + this.stringConverters.length + " parameters.");
        }
        StringBuilder b = new StringBuilder();
        b.append(this.name);
        int i = 0;
        while (i < parameters.length) {
            b.append(' ').append((String)this.stringConverters[i].apply((Object)context, parameters[i]));
            ++i;
        }
        CommandMetadata.add((WriteGraph)graph, (long)context.getResourceId(), (String)b.toString());
    }
}

