/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.export;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.RecordType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.FormatClass;
import org.simantics.export.core.manager.Content;
import org.simantics.history.HistoryException;
import org.simantics.history.csv.ColumnSeparator;
import org.simantics.history.csv.DecimalSeparator;
import org.simantics.simulation.export.CSVPreferences;
import org.simantics.simulation.export.CSVWriter;
import org.simantics.simulation.export.ExperimentExportClass;

public class CSVFormat
implements FormatClass {
    public static ChildReference P_CSV_COLUMN_SEPARATOR = ChildReference.parsePath((String)"Comma Separated Value (CSV)/Column Separator");
    public static ChildReference P_CSV_DECIMAL_SEPARATOR = ChildReference.parsePath((String)"Comma Separated Value (CSV)/Decimal Separator");
    public static ChildReference P_CSV_TIME_STEP = ChildReference.parsePath((String)"Comma Separated Value (CSV)/Time Step");
    static RecordType options;
    static RecordType csvOptions;

    static {
        DoubleType second = new DoubleType("s");
        csvOptions = new RecordType();
        csvOptions.addComponent("Time Step", (Datatype)second);
        csvOptions.addComponent("Column Separator", (Datatype)Datatypes.STRING);
        csvOptions.addComponent("Decimal Separator", (Datatype)Datatypes.STRING);
        options = new RecordType();
        options.addComponent("Comma Separated Value (CSV)", (Datatype)csvOptions);
    }

    public RecordType options(ExportContext context) throws ExportException {
        return options;
    }

    public List<String> validate(ExportContext context, Variant options) throws ExportException {
        return Collections.emptyList();
    }

    public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
        ScopedPreferenceStore csvnode = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling");
        Double timeStep = CSVPreferences.DEFAULT_CSV_TIME_STEP;
        String decimalSeparator = ".";
        String columnSeparator = "\t";
        Locale locale = Locale.getDefault();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        decimalSeparator = String.valueOf(symbols.getDecimalSeparator());
        String string = columnSeparator = decimalSeparator.equals(",") ? "\\t" : ",";
        if (csvnode != null) {
            if (csvnode.contains("csv.step")) {
                timeStep = csvnode.getDouble("csv.step");
            }
            if (csvnode.contains("csv.decimal.separator")) {
                decimalSeparator = csvnode.getString("csv.decimal.separator");
            }
            if (csvnode.contains("csv.value.separator")) {
                columnSeparator = csvnode.getString("csv.value.separator");
            }
        }
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            ra.setValue(P_CSV_COLUMN_SEPARATOR, (Binding)Bindings.STRING, (Object)columnSeparator);
            ra.setValue(P_CSV_DECIMAL_SEPARATOR, (Binding)Bindings.STRING, (Object)decimalSeparator);
            ra.setValue(P_CSV_TIME_STEP, (Binding)Bindings.DOUBLE, (Object)timeStep);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public void savePref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        try {
            Double timeStep;
            String decimalSeparator;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            String columnSeparator = (String)ra.getValue(P_CSV_COLUMN_SEPARATOR, (Binding)Bindings.STRING);
            if (columnSeparator != null) {
                workbenchScopeNode.put("csv.value.separator", columnSeparator);
            }
            if ((decimalSeparator = (String)ra.getValue(P_CSV_DECIMAL_SEPARATOR, (Binding)Bindings.STRING)) != null) {
                workbenchScopeNode.put("csv.decimal.separator", decimalSeparator);
            }
            if ((timeStep = (Double)ra.getValue(P_CSV_TIME_STEP, (Binding)Bindings.DOUBLE)) != null) {
                contentScopeNode.putDouble("csv.step", timeStep.doubleValue());
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public void loadPref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        try {
            Double timeStep;
            String decimalSeparator;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            String columnSeparator = workbenchScopeNode.get("csv.value.separator", null);
            if (columnSeparator != null) {
                ra.setValue(P_CSV_COLUMN_SEPARATOR, (Binding)Bindings.STRING, (Object)columnSeparator);
            }
            if ((decimalSeparator = workbenchScopeNode.get("csv.decimal.separator", null)) != null) {
                ra.setValue(P_CSV_DECIMAL_SEPARATOR, (Binding)Bindings.STRING, (Object)decimalSeparator);
            }
            if ((timeStep = Double.valueOf(contentScopeNode.getDouble("csv.step", 0.0))) != null) {
                ra.setValue(P_CSV_TIME_STEP, (Binding)Bindings.DOUBLE, (Object)timeStep);
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public Object createFile(ExportContext context, File outputFile, Variant options) throws ExportException {
        CSVWriter writer = new CSVWriter();
        writer.file = outputFile;
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            Double startTime = (Double)ra.getValue(ExperimentExportClass.P_EXPERIMENT_START, (Binding)Bindings.DOUBLE);
            Double endTime = (Double)ra.getValue(ExperimentExportClass.P_EXPERIMENT_END, (Binding)Bindings.DOUBLE);
            writer.setTimeRange(startTime, endTime);
            String columnSeparator = (String)ra.getValue(P_CSV_COLUMN_SEPARATOR, (Binding)Bindings.STRING);
            writer.setColumnSeparator(ColumnSeparator.fromPreference((String)columnSeparator));
            String decimalSeparator = (String)ra.getValue(P_CSV_DECIMAL_SEPARATOR, (Binding)Bindings.STRING);
            writer.setDecimalSeparator(DecimalSeparator.fromPreference((String)decimalSeparator));
            Double timeStep = (Double)ra.getValue(P_CSV_TIME_STEP, (Binding)Bindings.DOUBLE);
            writer.setTimeStep(timeStep);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
        return writer;
    }

    public Object openFile(ExportContext context, File inputFile, Variant options) throws ExportException {
        throw new ExportException("Not implemented");
    }

    public void closeFile(ExportContext context, Object handle_) throws ExportException {
        CSVWriter handle = (CSVWriter)((Object)handle_);
        try {
            handle.write();
        }
        catch (IOException e) {
            throw new ExportException((Throwable)e);
        }
        catch (HistoryException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public void addAttachment(ExportContext context, Object handle, List<Content> attachments) throws ExportException {
        throw new ExportException("Cannot add attachments to a CSV file.");
    }
}

