/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.content;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;

public final class EdgeResource
implements Iterable<Resource>,
Comparable<EdgeResource> {
    private final Resource first;
    private final Resource second;

    public EdgeResource(Resource first, Resource second) {
        this.first = first;
        this.second = second;
    }

    public String toString(ReadGraph g) throws DatabaseException {
        return "(" + NameUtils.getSafeName((ReadGraph)g, (Resource)this.first()) + ", " + NameUtils.getSafeName((ReadGraph)g, (Resource)this.second()) + ")";
    }

    public Resource first() {
        return this.first;
    }

    public Resource second() {
        return this.second;
    }

    public int hashCode() {
        return this.first.hashCode() + this.second.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EdgeResource)) {
            return false;
        }
        EdgeResource other = (EdgeResource)obj;
        return this.first.equals(other.first) && this.second.equals(other.second) || this.first.equals(other.second) && this.second.equals(other.first);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append('(');
        sb.append(this.first.getResourceId());
        sb.append(',');
        sb.append(this.second.getResourceId());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public Iterator<Resource> iterator() {
        return new Iterator<Resource>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i == 0;
            }

            @Override
            public Resource next() {
                ++this.i;
                switch (this.i) {
                    case 1: {
                        return EdgeResource.this.first();
                    }
                    case 2: {
                        return EdgeResource.this.second();
                    }
                }
                throw new NoSuchElementException("element " + this.i + "is out of bounds, only two elements exist.");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private final long id() {
        return this.first.getResourceId() + this.second.getResourceId();
    }

    @Override
    public int compareTo(EdgeResource arg0) {
        long i2;
        long i = this.id();
        if (i == (i2 = arg0.id())) {
            return 0;
        }
        if (i < i2) {
            return -1;
        }
        return 1;
    }
}

