/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.JTableSG;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.OperationMode;
import org.simantics.spreadsheet.ui.CellValue;
import org.simantics.spreadsheet.ui.ClientTableModel;
import org.simantics.spreadsheet.ui.Renderer;
import org.simantics.spreadsheet.ui.RowHeaderRenderer;
import org.simantics.spreadsheet.ui.Spreadsheet;
import org.simantics.spreadsheet.ui.SpreadsheetCellEditor;
import org.simantics.spreadsheet.ui.TextTableCellEditor;

public class SpreadsheetTable
extends JTableSG {
    public static final String uiClassID = "SpreadsheetTableUI";
    private final CellEditor cellEditor;
    private ClientModel clientModel;
    private final DefaultListModel rowModel;
    private final JList rowHeader;
    private static final long serialVersionUID = -4592686559195294773L;

    public int getRowHeight() {
        Font font = this.getFont();
        if (font != null) {
            return font.getSize() + 4;
        }
        return super.getRowHeight();
    }

    public SpreadsheetTable(INode node, CellEditor cellEditor, ClientModel clientModel, DefaultListModel rowModel) {
        super((TableModel)new ClientTableModel(clientModel), node);
        this.rowHeader = null;
        this.cellEditor = cellEditor;
        this.clientModel = clientModel;
        this.rowModel = rowModel;
        this.setDefaultRenderer(Object.class, new Renderer());
        this.setShowGrid(false);
        this.setRowMargin(0);
    }

    public SpreadsheetTable(INode node, CellEditor cellEditor, ClientModel clientModel, DefaultListModel rowModel, JList rowHeader) {
        super((TableModel)new ClientTableModel(clientModel), node);
        this.rowHeader = rowHeader;
        this.cellEditor = cellEditor;
        this.clientModel = clientModel;
        this.rowModel = rowModel;
        this.setDefaultRenderer(Object.class, new Renderer());
        this.setShowGrid(false);
        this.setRowMargin(0);
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle span;
        if (this.clientModel != null && (span = this.clientModel.getSpan(row, column)) != null) {
            Rectangle rect1 = super.getCellRect(span.y, span.x, includeSpacing);
            Rectangle rect2 = super.getCellRect(span.y + span.height - 1, span.x + span.width - 1, includeSpacing);
            return rect1.union(rect2);
        }
        return super.getCellRect(row, column, includeSpacing);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int rowAtPoint(Point p) {
        int row = super.rowAtPoint(p);
        if (row == -1) {
            return -1;
        }
        int column = super.columnAtPoint(p);
        Rectangle span = this.clientModel.getSpan(row, column);
        if (span != null) {
            return span.y;
        }
        return row;
    }

    public int columnAtPoint(Point p) {
        int column = super.columnAtPoint(p);
        if (column == -1) {
            return -1;
        }
        int row = super.rowAtPoint(p);
        Rectangle span = this.clientModel.getSpan(row, column);
        if (span != null) {
            return span.x;
        }
        return column;
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.repaint();
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        this.repaint();
    }

    public ClientModel getClientModel() {
        return this.clientModel;
    }

    protected int rowAtPointWithoutSpan(Point p) {
        return super.rowAtPoint(p);
    }

    protected int columnAtPointWithoutSpan(Point p) {
        return super.columnAtPoint(p);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 127) {
            this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
            boolean retvalue = super.processKeyBinding(ks, e, condition, pressed);
            this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
            return retvalue;
        }
        boolean retValue = super.processKeyBinding(ks, e, condition, pressed);
        return retValue;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (this.cellEditor == null) {
            return null;
        }
        boolean editable = false;
        OperationMode mode = (OperationMode)this.clientModel.getPropertyAt("Mode", "current");
        if (!OperationMode.OPERATION.equals((Object)mode)) {
            editable = true;
        }
        CellValue cellValue = (CellValue)this.getValueAt(row, column);
        editable = cellValue.editable;
        if (editable) {
            String initial = ((CellValue)this.getValueAt((int)row, (int)column)).label;
            return new TextTableCellEditor(row, column, initial, this.cellEditor, this.clientModel);
        }
        return null;
    }

    public void editingStopped(ChangeEvent e) {
        SpreadsheetCellEditor editor = (SpreadsheetCellEditor)((Object)this.getCellEditor());
        if (editor != null) {
            int[] rc = this.getSelectedRows();
            editor.commit();
            this.removeEditor();
            if (rc.length == 1 && rc[0] < this.getRowCount() - 1) {
                this.setRowSelectionInterval(rc[0] + 1, rc[0] + 1);
            }
        }
    }

    public void applyRowLabels(String[] rowLabels) {
        if (Spreadsheet.DEBUG) {
            System.out.println("Apply row labels: " + Arrays.toString(rowLabels));
        }
        this.rowModel.ensureCapacity(rowLabels.length);
        int i = 0;
        while (i < rowLabels.length && i < this.rowModel.size()) {
            this.rowModel.setElementAt(rowLabels[i], i);
            ++i;
        }
        while (i < rowLabels.length) {
            this.rowModel.addElement(rowLabels[i]);
            ++i;
        }
    }

    public void applyHeaderSizes(ClientModel clientModel) {
        if (clientModel == null) {
            return;
        }
        int[] rows = (int[])clientModel.getPropertyAt("Headers", "rowHeights");
        int[] cols = (int[])clientModel.getPropertyAt("Headers", "columnWidths");
        int i = 0;
        while (i < this.getColumnModel().getColumnCount() && i < cols.length) {
            TableColumn column = this.getColumnModel().getColumn(i);
            int preferred = cols[i];
            if (preferred > 0) {
                column.setPreferredWidth(preferred);
            }
            ++i;
        }
        if (this.rowHeader != null) {
            this.rowHeader.setCellRenderer(new RowHeaderRenderer((JTable)((Object)this)));
        }
        i = 0;
        while (i < this.getRowCount() && i < rows.length) {
            if (rows[i] > 0) {
                this.setRowHeight(i, rows[i]);
            }
            ++i;
        }
    }

    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        this.applyHeaderSizes(this.clientModel);
    }

    protected TableColumnModel createDefaultColumnModel() {
        TableColumnModel model = super.createDefaultColumnModel();
        model.setColumnMargin(0);
        return model;
    }
}

