/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.function;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.db.function.DbFunction;
import org.simantics.db.function.DbPredicate;
import org.simantics.db.function.DbSupplier;

public final class DbOptional<T> {
    private static final DbOptional<?> EMPTY = new DbOptional();
    private final T value;

    private DbOptional() {
        this.value = null;
    }

    public static <T> DbOptional<T> empty() {
        DbOptional<?> t = EMPTY;
        return t;
    }

    private DbOptional(T value) {
        this.value = Objects.requireNonNull(value);
    }

    public static <T> DbOptional<T> of(T value) {
        return new DbOptional<T>(value);
    }

    public static <T> DbOptional<T> ofNullable(T value) {
        return value == null ? DbOptional.empty() : DbOptional.of(value);
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(DbConsumer<? super T> consumer) throws DatabaseException {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public DbOptional<T> filter(DbPredicate<? super T> predicate) throws DatabaseException {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : DbOptional.empty();
    }

    public <U> DbOptional<U> map(DbFunction<? super T, ? extends U> mapper) throws DatabaseException {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return DbOptional.empty();
        }
        return DbOptional.ofNullable(mapper.apply(this.value));
    }

    public <U> DbOptional<U> flatMap(DbFunction<? super T, DbOptional<U>> mapper) throws DatabaseException {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return DbOptional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.value));
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(DbSupplier<? extends T> other) throws DatabaseException {
        return this.value != null ? this.value : other.get();
    }

    public <X extends Throwable> T orElseThrow(DbSupplier<? extends X> exceptionSupplier) throws X, DatabaseException {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DbOptional)) {
            return false;
        }
        DbOptional other = (DbOptional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("DbOptional[%s]", this.value) : "DbOptional.empty";
    }
}

