/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.Simantics;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.common.BatchIssueDescriptions;
import org.simantics.issues.common.BatchIssueSource;
import org.simantics.issues.common.BatchIssueValidationContext;
import org.simantics.issues.common.ComposedValidation;
import org.simantics.issues.common.IssueByList;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class BatchValidations {
    private static final boolean PERF = false;

    public static Map<Resource, Set<Issue>> validate(IProgressMonitor monitor, BatchIssueSource source, BatchIssueValidationContext context) throws DatabaseException {
        Session session = Simantics.getSession();
        return (Map)session.syncRequest((Read)new ComposedValidation(monitor, source, context));
    }

    public static int store(IProgressMonitor monitor, Resource source, Map<Resource, Set<Issue>> issues) throws DatabaseException {
        return BatchValidations.store(monitor, source, issues, Integer.MAX_VALUE);
    }

    public static int store(final IProgressMonitor monitor, final Resource source, final Map<Resource, Set<Issue>> issues, final int maxIssuesToWrite) throws DatabaseException {
        if (issues.isEmpty() || maxIssuesToWrite <= 0) {
            return 0;
        }
        Session session = Simantics.getSession();
        VirtualGraphSupport support = (VirtualGraphSupport)session.getService(VirtualGraphSupport.class);
        VirtualGraph vg = support.getWorkspacePersistent("issues");
        final int[] writtenIssues = new int[1];
        session.syncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                for (Map.Entry entry : issues.entrySet()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    Resource context = (Resource)entry.getKey();
                    Set current = (Set)entry.getValue();
                    Set existing = (Set)graph.sync((ReadInterface)new BatchIssueDescriptions(source, context));
                    if (existing.equals(current)) continue;
                    THashSet added = new THashSet((Collection)current);
                    THashSet removed = new THashSet((Collection)existing);
                    added.removeAll(existing);
                    removed.removeAll(current);
                    for (Issue add : added) {
                        add.write(graph, source);
                        writtenIssues[0] = writtenIssues[0] + 1;
                        if (writtenIssues[0] < maxIssuesToWrite) continue;
                        return;
                    }
                    for (Issue remove : removed) {
                        Resource issue = (Resource)graph.sync((ReadInterface)new IssueByList(source, remove));
                        if (issue == null) continue;
                        graph.deny(issue, Layer0.getInstance((ReadGraph)graph).PartOf);
                        graph.deny(source, IssueResource.getInstance((ReadGraph)graph).IssueSource_Manages, issue);
                        RemoverUtil.remove((WriteGraph)graph, (Resource)issue);
                    }
                }
            }
        });
        return writtenIssues[0];
    }

    private static int count(Map map) {
        int result = 0;
        for (Object obj : map.values()) {
            if (!(obj instanceof Set)) continue;
            Set set = (Set)obj;
            result += set.size();
        }
        return result;
    }

    public static boolean isLinkedToOtherThan(ReadGraph graph, Resource resourceToCheckForLinks, Resource excludeLinksTo) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Statement stm : graph.getStatements(resourceToCheckForLinks, L0.IsWeaklyRelatedTo)) {
            Resource o;
            if (stm.isAsserted(resourceToCheckForLinks) || stm.getPredicate().equals(L0.InstanceOf) || (o = stm.getObject()).equals(excludeLinksTo) || o.equals(resourceToCheckForLinks)) continue;
            return true;
        }
        return false;
    }
}

