/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import org.simantics.db.debug.ListenerReport;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.ListenerEntry;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.UpdateEntry;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryListening {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryListening.class);
    private final QueryProcessor processor;
    private THashSet<ListenerEntry> scheduledListeners = new THashSet();
    private boolean firingListeners = false;
    final THashMap<CacheEntry, ArrayList<ListenerEntry>> listeners = new THashMap(10, 0.75f);
    private BlockingQueue<Runnable> tasks = new ArrayBlockingQueue<Runnable>(2048);
    private Map<ListenerBase, ListenerEntry> addedEntries = new HashMap<ListenerBase, ListenerEntry>();

    QueryListening(QueryProcessor processor) {
        this.processor = processor;
        new DependencyManagementThread(processor, this.tasks).start();
    }

    public void sync() {
        Semaphore s = new Semaphore(0);
        try {
            this.tasks.put(() -> s.release());
            s.acquire();
        }
        catch (Throwable t) {
            LOGGER.error("Error while waiting for query dependency management", t);
        }
    }

    public boolean hasScheduledUpdates() {
        return !this.scheduledListeners.isEmpty();
    }

    void registerDependencies(ReadGraphImpl graph, CacheEntry child, CacheEntry parent, ListenerBase listener, Object procedure, boolean inferred) {
        try {
            this.tasks.put(() -> {
                if (parent != null && !inferred) {
                    try {
                        if (!child.isImmutable(graph)) {
                            child.addParent(parent);
                        }
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("Error while registering query dependencies", (Throwable)e);
                    }
                }
                if (listener != null) {
                    this.registerListener(child, listener, procedure);
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.error("Error while registering dependencies", (Throwable)e);
        }
    }

    void registerFirstKnown(ListenerBase base, Object result) {
        this.tasks.offer(() -> {
            ListenerEntry entry = this.addedEntries.get(base);
            if (entry != null) {
                entry.setLastKnown(result);
            }
        });
    }

    public ListenerEntry registerListener(CacheEntry entry, ListenerBase base, Object procedure) {
        assert (entry != null);
        if (base.isDisposed()) {
            return null;
        }
        return this.addListener(entry, base, procedure);
    }

    private ListenerEntry addListener(CacheEntry entry, ListenerBase base, Object procedure) {
        ListenerEntry result;
        int currentIndex;
        assert (entry != null);
        assert (procedure != null);
        ArrayList<ListenerEntry> list = (ArrayList<ListenerEntry>)this.listeners.get((Object)entry);
        if (list == null) {
            list = new ArrayList<ListenerEntry>(1);
            this.listeners.put((Object)entry, list);
        }
        if ((currentIndex = list.indexOf(result = new ListenerEntry(entry, base, procedure))) > -1) {
            ListenerEntry current = (ListenerEntry)list.get(currentIndex);
            if (!current.base.isDisposed()) {
                return null;
            }
            list.set(currentIndex, result);
        } else {
            list.add(result);
        }
        this.addedEntries.put(base, result);
        return result;
    }

    void scheduleListener(ListenerEntry entry) {
        assert (entry != null);
        this.scheduledListeners.add((Object)entry);
    }

    private void removeListener(ListenerEntry entry) {
        assert (entry != null);
        ArrayList list = (ArrayList)this.listeners.get((Object)entry.entry);
        if (list == null) {
            return;
        }
        boolean success = list.remove(entry);
        assert (success);
        if (list.isEmpty()) {
            this.listeners.remove((Object)entry.entry);
        }
    }

    boolean hasListener(CacheEntry entry) {
        return this.listeners.get((Object)entry) != null;
    }

    boolean hasListenerAfterDisposing(CacheEntry entry) {
        if (this.listeners.get((Object)entry) != null) {
            ArrayList entries = (ArrayList)this.listeners.get((Object)entry);
            ArrayList<ListenerEntry> list = null;
            for (ListenerEntry e : entries) {
                if (!e.base.isDisposed()) continue;
                if (list == null) {
                    list = new ArrayList<ListenerEntry>();
                }
                list.add(e);
            }
            if (list != null) {
                for (ListenerEntry e : list) {
                    entries.remove(e);
                }
            }
            if (entries.isEmpty()) {
                this.listeners.remove((Object)entry);
                return false;
            }
            return true;
        }
        return false;
    }

    List<ListenerEntry> getListenerEntries(CacheEntry entry) {
        this.hasListenerAfterDisposing(entry);
        if (this.listeners.get((Object)entry) != null) {
            return (List)this.listeners.get((Object)entry);
        }
        return Collections.emptyList();
    }

    void processListenerReport(CacheEntry<?> entry, Map<CacheEntry, Set<ListenerBase>> workarea) {
        if (!workarea.containsKey(entry)) {
            HashSet<ListenerBase> ls = new HashSet<ListenerBase>();
            for (ListenerEntry listenerEntry : this.getListenerEntries(entry)) {
                ls.add(listenerEntry.base);
            }
            workarea.put(entry, ls);
            for (CacheEntry cacheEntry : entry.getParents(this.processor)) {
                this.processListenerReport(cacheEntry, workarea);
                ls.addAll((Collection)workarea.get(cacheEntry));
            }
        }
    }

    public synchronized ListenerReport getListenerReport() throws IOException {
        class ListenerReportImpl
        implements ListenerReport {
            Map<CacheEntry, Set<ListenerBase>> workarea = new HashMap<CacheEntry, Set<ListenerBase>>();

            ListenerReportImpl() {
            }

            public void print(PrintStream b) {
                HashMap<ListenerBase, Integer> hist = new HashMap<ListenerBase, Integer>();
                for (Map.Entry<CacheEntry, Set<ListenerBase>> e : this.workarea.entrySet()) {
                    Iterator<ListenerBase> iterator = e.getValue().iterator();
                    while (iterator.hasNext()) {
                        ListenerBase l;
                        Integer i = (Integer)hist.get(l = iterator.next());
                        hist.put(l, i != null ? i - 1 : -1);
                    }
                }
                for (Pair p : CollectionUtils.valueSortedEntries(hist)) {
                    b.print(-((Integer)p.second).intValue() + " " + p.first + "\n");
                }
                b.flush();
            }
        }
        ListenerReportImpl result = new ListenerReportImpl();
        Collection<CacheEntryBase> all = this.processor.allCaches(new CacheCollectionResult()).toCollection();
        for (CacheEntryBase entry : all) {
            this.hasListenerAfterDisposing(entry);
        }
        for (CacheEntryBase entry : all) {
            this.processListenerReport(entry, result.workarea);
        }
        return result;
    }

    public synchronized String reportListeners(File file) throws IOException {
        if (!this.processor.isAlive()) {
            return "Disposed!";
        }
        PrintStream b = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        ListenerReport report = this.getListenerReport();
        report.print(b);
        return "Done reporting listeners.";
    }

    public void fireListeners(WriteGraphImpl graph) {
        assert (!this.processor.updating);
        assert (!this.processor.cache.collecting);
        assert (!this.firingListeners);
        this.firingListeners = true;
        try {
            while (!this.scheduledListeners.isEmpty()) {
                CacheEntry entry;
                THashSet<ListenerEntry> entries = this.scheduledListeners;
                this.scheduledListeners = new THashSet();
                ArrayList<ListenerEntry> schedule = new ArrayList<ListenerEntry>();
                for (ListenerEntry listenerEntry : entries) {
                    if (this.pruneListener(listenerEntry)) continue;
                    entry = listenerEntry.entry;
                    assert (entry != null);
                    Object newValue = this.processor.compareTo(graph, entry, listenerEntry.getLastKnown());
                    if (newValue == ListenerEntry.NOT_CHANGED) continue;
                    schedule.add(listenerEntry);
                    listenerEntry.setLastKnown(entry.getResult());
                }
                for (ListenerEntry listenerEntry : schedule) {
                    entry = listenerEntry.entry;
                    try {
                        entry.performFromCache(graph, listenerEntry.procedure);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
        finally {
            this.firingListeners = false;
        }
    }

    void updateParents(int indent, CacheEntry entry, LinkedList<UpdateEntry> todo) {
        Iterable<CacheEntry<?>> oldParents = entry.getParents(this.processor);
        for (CacheEntry<?> parent : oldParents) {
            if (parent.isDiscarded()) continue;
            todo.push(new UpdateEntry(entry, parent, indent + 2));
        }
    }

    private boolean pruneListener(ListenerEntry entry) {
        if (entry.base.isDisposed()) {
            this.removeListener(entry);
            return true;
        }
        return false;
    }

    static class DependencyManagementThread
    extends Thread {
        private final QueryProcessor processor;
        final BlockingQueue<Runnable> tasks;

        DependencyManagementThread(QueryProcessor processor, BlockingQueue<Runnable> tasks) {
            this.setName("Query Dependency Manager");
            this.processor = processor;
            this.tasks = tasks;
        }

        @Override
        public void run() {
            while (this.processor.isAlive()) {
                try {
                    Runnable r = this.tasks.take();
                    r.run();
                }
                catch (Throwable t) {
                    LOGGER.error("Error while waiting for query dependency management tasks", t);
                }
            }
        }
    }
}

