/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Databoard;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.export.core.ExportExtensionPoint;
import org.simantics.export.core.manager.Content;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.utils.ui.AdaptionUtils;

public class ExportContext {
    public ISessionContext sessionCtx;
    public Session session;
    public String project;
    public List<String> activeModels;
    public List<String> selection;
    public ExportExtensionPoint eep;
    public File workarea;
    public Preferences store;
    public Databoard databoard;

    public static ExportContext create(ISessionContext ctx, final IStructuredSelection selection) throws DatabaseException {
        final ExportContext result = new ExportContext();
        result.sessionCtx = ctx;
        result.session = ctx.getSession();
        result.selection = new ArrayList<String>();
        result.activeModels = new ArrayList<String>();
        result.workarea = Platform.getLocation().toFile();
        result.store = ConfigurationScope.INSTANCE.getNode("org.simantics.export.core");
        result.databoard = new Databoard();
        result.session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Resource project;
                IProject iproject = (IProject)result.sessionCtx.getHint(ProjectKeys.KEY_PROJECT);
                Resource resource = project = iproject == null ? null : (Resource)iproject.get();
                if (project != null) {
                    result.project = graph.getURI(project);
                }
                for (Resource activeModel : (Collection)graph.sync((ReadInterface)new ActiveModels(project))) {
                    try {
                        result.activeModels.add(graph.getURI(activeModel));
                    }
                    catch (AssumptionException assumptionException) {
                    }
                    catch (ValidationException validationException) {
                    }
                    catch (ServiceException serviceException) {}
                }
                if (selection != null) {
                    for (Resource r : AdaptionUtils.adaptToCollection((Object)selection, Resource.class)) {
                        try {
                            result.selection.add(graph.getURI(r));
                        }
                        catch (AssumptionException assumptionException) {
                        }
                        catch (ValidationException validationException) {
                        }
                        catch (ServiceException serviceException) {}
                    }
                }
            }
        });
        return result;
    }

    public Preferences store(List<Content> contents) {
        int hash = ExportContext._hash(contents);
        return this.store.node("Selection-" + hash);
    }

    public static int _hash(List<Content> contents) {
        int hash = 0x234234;
        for (Content c : contents) {
            hash = 13 * hash + c.url.hashCode();
            hash = 13 * hash + c.formatId.hashCode();
        }
        return hash;
    }
}

