/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.tests.diff;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.diff.Diff;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class TestDiff {
    public static TransferableGraph1 load(String name) throws IOException {
        InputStream stream = TestDiff.class.getResourceAsStream(name);
        Bindings.getSerializerUnchecked(Datatype.class).skip(stream);
        TransferableGraph1 result = (TransferableGraph1)TransferableGraph1.SERIALIZER.deserialize(stream);
        stream.close();
        return result;
    }

    public static int[] randomPermutation(int size) {
        Random rand = new Random();
        int[] permutation = new int[size];
        int i = 0;
        while (i < size) {
            permutation[i] = i;
            ++i;
        }
        i = size - 1;
        while (i > 0) {
            int j = rand.nextInt(i + 1);
            int temp = permutation[i];
            permutation[i] = permutation[j];
            permutation[j] = temp;
            --i;
        }
        return permutation;
    }

    public static void shuffle(TransferableGraph1 tg) {
        int[] permutation = TestDiff.randomPermutation(tg.resourceCount);
        int[] statements = tg.statements;
        int i = 0;
        while (i < statements.length) {
            int r = statements[i];
            if (r >= 0) {
                statements[i] = permutation[r];
            }
            ++i;
        }
        Object[] objectArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            IdentityDefinition def;
            Identity id = objectArray[n2];
            id.resource = permutation[id.resource];
            if (id.definition instanceof External) {
                def = (External)id.definition;
                def.parent = permutation[def.parent];
            } else if (id.definition instanceof Internal) {
                def = (Internal)id.definition;
                ((Internal)def).parent = permutation[((Internal)def).parent];
            } else if (id.definition instanceof Optional) {
                def = (Optional)id.definition;
                ((Optional)def).parent = permutation[((Optional)def).parent];
            }
            ++n2;
        }
        objectArray = tg.values;
        n = tg.values.length;
        n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            ((Value)value).resource = permutation[((Value)value).resource];
            ++n2;
        }
    }

    public static void main(String[] args) throws Exception {
        TransferableGraph1 graphOld = TestDiff.load("layer0.tg");
        TransferableGraph1 graphNew = TestDiff.load("layer0.tg");
        TestDiff.shuffle(graphNew);
        long begin = System.nanoTime();
        Diff diff = new Diff(graphOld, graphNew);
        diff.diff();
        long end = System.nanoTime();
        System.out.println("Total time: " + (double)(end - begin) * 1.0E-6 + "ms");
    }
}

