/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.BooleanConstant;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.JavaConstructor;
import org.simantics.scl.compiler.constants.JavaMethod;
import org.simantics.scl.compiler.constants.NoRepConstant;
import org.simantics.scl.compiler.constants.generic.CallJava;
import org.simantics.scl.compiler.constants.generic.MethodRef;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.chr.CHRRulesetObject;
import org.simantics.scl.compiler.elaboration.chr.analysis.CHRConstraintGGInfo;
import org.simantics.scl.compiler.elaboration.chr.analysis.UsageAnalysis;
import org.simantics.scl.compiler.elaboration.chr.plan.CHRSearchPlan;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanRealizer;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.block.IncludeStatement;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.internal.codegen.chr.CHRRuntimeRulesetCodeGenerator;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class CHRRuleset
extends Symbol {
    public static final String INIT_CONSTRAINT = "__INIT__";
    public ArrayList<CHRConstraint> constraints = new ArrayList();
    public ArrayList<CHRRule> rules = new ArrayList();
    public ArrayList<IncludeStatement> includes = new ArrayList();
    public THashMap<CHRConstraint, IncludeStatement> constraintSourceMap = new THashMap();
    public THashMap<CHRConstraint, CHRConstraintGGInfo> activeConstraintGGInfo = new THashMap();
    public THashMap<IncludeStatement, ArrayList<CHRConstraint>> inverseActiveConstraintSourceMap = new THashMap();
    public boolean extensible;
    public CHRConstraint initConstraint = new CHRConstraint(9223372034707292160L, "__INIT__", Type.EMPTY_ARRAY);
    public int priorityCount;
    public int initialPriorityNumber = 0;
    public String runtimeRulesetClassName;
    public TCon runtimeRulesetType;
    public BoundVar runtimeRulesetVariable;
    public TypeDesc runtimeRulesetTypeDesc;
    public static final Constant READ_CURRENT_ID = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, (Type)Types.INTEGER, new Type[]{Types.CHRContext}, null, new MethodRef.FieldRef("org/simantics/scl/runtime/chr/CHRContext", "currentId", CHRRuntimeRulesetCodeGenerator.FACT_ID_TYPE), null);
    public static final Constant WRITE_CURRENT_ID = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, (Type)Types.UNIT, new Type[]{Types.CHRContext, Types.INTEGER}, null, new MethodRef.SetFieldRef("org/simantics/scl/runtime/chr/CHRContext", "currentId", CHRRuntimeRulesetCodeGenerator.FACT_ID_TYPE), null);
    public static final Constant GENERATE_ID = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, (Type)Types.INTEGER, new Type[]{Types.CHRContext}, null, new MethodRef.ObjectMethodRef(false, "org/simantics/scl/runtime/chr/CHRContext", "generateId", CHRRuntimeRulesetCodeGenerator.FACT_ID_TYPE, Constants.EMPTY_TYPEDESC_ARRAY), null);
    private CompilationContext cachedContext;
    public CHRRulesetObject rulesetObject;
    public SSAFunction initializer;
    public SSAFunction deinitializer;
    public static final Constant ACTIVATE = new JavaMethod(true, "org/simantics/scl/runtime/chr/CHRContext", "activate", (Type)Types.PROC, (Type)Types.UNIT, Types.CHRContext, Types.INTEGER);
    private static final Constant CREATE_CHR_CONTEXT = new JavaConstructor("org/simantics/scl/runtime/chr/CHRContext", (Type)Types.PROC, (Type)Types.CHRContext, new Type[0]);

    public CHRRuleset() {
        this.addConstraint(this.initConstraint);
    }

    public void addConstraint(CHRConstraint constraint) {
        this.constraints.add(constraint);
        constraint.setParent(this);
    }

    public void resolve(TranslationContext context) {
        boolean failedIncludes = false;
        for (IncludeStatement include : this.includes) {
            try {
                include.ruleset = context.resolveRuleset(include.name.text);
                if (include.ruleset == null) {
                    failedIncludes = true;
                    context.getErrorLog().log(include.name.location, "Couldn't resolve ruleset " + include.name + ".");
                    continue;
                }
                include.value = include.value.resolve(context);
                for (CHRConstraint constraint : include.ruleset.constraints) {
                    context.newCHRConstraint(constraint.name, constraint);
                    this.constraintSourceMap.put((Object)constraint, (Object)include);
                }
            }
            catch (AmbiguousNameException e) {
                failedIncludes = true;
                context.getErrorLog().log(include.name.location, e.getMessage());
            }
        }
        if (failedIncludes) {
            return;
        }
        for (CHRConstraint constraint : this.constraints) {
            context.newCHRConstraint(constraint.name, constraint);
        }
        this.priorityCount = 0;
        for (CHRRule rule : this.rules) {
            rule.resolve(context);
            ++this.priorityCount;
            rule.priority = rule.priority;
        }
    }

    public void checkType(TypingContext context) {
        for (IncludeStatement include : this.includes) {
            include.value = include.value.checkType(context, include.ruleset.runtimeRulesetType);
        }
        for (CHRRule rule : this.rules) {
            rule.checkType(context);
        }
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        for (IncludeStatement include : this.includes) {
            include.value.collectVars(allVars, vars);
        }
        for (CHRRule rule : this.rules) {
            rule.collectVars(allVars, vars);
        }
    }

    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            for (CHRRule rule : this.rules) {
                rule.setLocationDeep(loc);
            }
        }
    }

    public int getMinimumPriority(CHRConstraint constraint) {
        CHRConstraintGGInfo info = (CHRConstraintGGInfo)this.activeConstraintGGInfo.get((Object)constraint);
        if (info == null) {
            return Integer.MAX_VALUE;
        }
        return info.minimumPriority;
    }

    public int getAndUpdateNextPriority(CHRConstraint constraint, int nextPriority) {
        CHRConstraintGGInfo info = (CHRConstraintGGInfo)this.activeConstraintGGInfo.get((Object)constraint);
        if (info == null) {
            return Integer.MAX_VALUE;
        }
        int result = info.nextPriority;
        info.nextPriority = nextPriority;
        return result;
    }

    private void compile(SimplificationContext context) {
        try {
            this.initializeCodeGeneration(context.getCompilationContext());
            if (this.extensible) {
                this.applyExtensibleDefaults();
            }
            UsageAnalysis.analyzeUsage(this);
            for (CHRRule rule : this.rules) {
                rule.compile(context.getCompilationContext(), this.initConstraint);
                for (CHRSearchPlan plan : rule.plans) {
                    CHRConstraint constraint = plan.constraint;
                    if (this.activeConstraintGGInfo.containsKey((Object)constraint)) continue;
                    this.activeConstraintGGInfo.put((Object)constraint, (Object)new CHRConstraintGGInfo(rule.priority));
                    IncludeStatement include = (IncludeStatement)this.constraintSourceMap.get((Object)constraint);
                    if (include == null) continue;
                    ArrayList<CHRConstraint> list = (ArrayList<CHRConstraint>)this.inverseActiveConstraintSourceMap.get((Object)include);
                    if (list == null) {
                        list = new ArrayList<CHRConstraint>(4);
                        this.inverseActiveConstraintSourceMap.put((Object)include, list);
                    }
                    list.add(constraint);
                }
            }
            if (this.getMinimumPriority(this.initConstraint) == Integer.MAX_VALUE) {
                this.constraints.remove(0);
                this.initConstraint = null;
            }
        }
        catch (Exception e) {
            throw InternalCompilerError.injectLocation(this.location, e);
        }
    }

    private void applyExtensibleDefaults() {
        for (CHRConstraint constraint : this.constraints) {
            int max = 1 << constraint.parameterTypes.length;
            int i = 0;
            while (i < max) {
                constraint.getOrCreateIndex(this.cachedContext, i);
                ++i;
            }
            constraint.setMayBeRemoved();
        }
    }

    private void simplify(SimplificationContext context) {
        for (IncludeStatement include : this.includes) {
            include.value = include.value.simplify(context);
        }
        for (CHRRule rule : this.rules) {
            rule.simplify(context);
        }
    }

    public void simplifyAndCompileIfNeeded(SimplificationContext context) {
        if (this.runtimeRulesetTypeDesc == null) {
            this.simplify(context);
            this.compile(context);
        }
    }

    public void setRulesetType(TCon type, String className) {
        this.runtimeRulesetType = type;
        this.runtimeRulesetClassName = className;
    }

    public void initializeCodeGeneration(CompilationContext context) {
        this.cachedContext = context;
        boolean createTypeDesc = false;
        if (this.runtimeRulesetType == null) {
            String suffix = context.namingPolicy.getFreshClosureClassNameSuffix();
            this.setRulesetType(Types.con(context.namingPolicy.getModuleName(), "CHR" + suffix), String.valueOf(context.namingPolicy.getModuleClassName()) + suffix);
            createTypeDesc = true;
        }
        this.runtimeRulesetTypeDesc = TypeDesc.forClass(this.runtimeRulesetClassName);
        this.runtimeRulesetVariable = new BoundVar(this.runtimeRulesetType);
        for (CHRConstraint constraint : this.constraints) {
            constraint.initializeCodeGeneration(context, this);
        }
        if (createTypeDesc && context.module != null) {
            context.module.addTypeDescriptor(this.runtimeRulesetType.name, new StandardTypeConstructor(this.runtimeRulesetType, TVar.EMPTY_ARRAY, this.runtimeRulesetTypeDesc));
        }
    }

    public IVal generateCode(CodeWriter w) {
        for (IncludeStatement include : this.includes) {
            include.storeVar = include.value.toVal(this.cachedContext, w);
            this.initialPriorityNumber = Math.max(this.initialPriorityNumber, include.ruleset.initialPriorityNumber + include.ruleset.priorityCount);
        }
        CHRRulesetObject object = new CHRRulesetObject(this.runtimeRulesetVariable, this);
        w.defineObject(object);
        for (CHRRule rule : this.rules) {
            for (CHRSearchPlan plan : rule.plans) {
                CodeWriter methodWriter = object.createMethod(w.getModuleWriter(), TVar.EMPTY_ARRAY, Types.PROC, Types.BOOLEAN, new Type[]{Types.CHRContext, plan.constraint.factType});
                plan.implementation = methodWriter.getFunction();
                IVal[] implementationParameters = methodWriter.getParameters();
                plan.activeFact.setVal(implementationParameters[1]);
                PlanRealizer realizer = new PlanRealizer(this.cachedContext, this, this.runtimeRulesetVariable, implementationParameters[0], plan.ops);
                realizer.nextOp(methodWriter);
                if (!methodWriter.isUnfinished()) continue;
                methodWriter.return_(rule.location, BooleanConstant.TRUE);
            }
        }
        if (!this.includes.isEmpty() || this.extensible) {
            CodeWriter methodWriter = object.createMethod(w.getModuleWriter(), TVar.EMPTY_ARRAY, Types.PROC, Types.UNIT, new Type[]{Types.CHRContext});
            this.initializer = methodWriter.getFunction();
            for (IncludeStatement include : this.includes) {
                methodWriter.apply(include.location, new JavaMethod(true, this.runtimeRulesetClassName, "register", (Type)Types.PROC, (Type)Types.UNIT, this.runtimeRulesetType, Types.CHRContext, include.ruleset.runtimeRulesetType), object.getTarget(), methodWriter.getParameters()[0], include.storeVar);
            }
            if (this.extensible) {
                methodWriter.apply(9223372034707292160L, new JavaMethod(true, this.runtimeRulesetClassName, "register", (Type)Types.PROC, (Type)Types.UNIT, this.runtimeRulesetType, Types.CHRContext), object.getTarget(), methodWriter.getParameters()[0]);
            }
            methodWriter.return_(this.location, NoRepConstant.UNIT);
            methodWriter = object.createMethod(w.getModuleWriter(), TVar.EMPTY_ARRAY, Types.PROC, Types.UNIT, new Type[]{Types.CHRContext});
            this.deinitializer = methodWriter.getFunction();
            for (IncludeStatement include : this.includes) {
                methodWriter.apply(include.location, new JavaMethod(true, this.runtimeRulesetClassName, "unregister", (Type)Types.PROC, (Type)Types.UNIT, this.runtimeRulesetType, Types.CHRContext, include.ruleset.runtimeRulesetType), object.getTarget(), methodWriter.getParameters()[0], include.storeVar);
            }
            if (this.extensible) {
                methodWriter.apply(9223372034707292160L, new JavaMethod(true, this.runtimeRulesetClassName, "unregister", (Type)Types.PROC, (Type)Types.UNIT, this.runtimeRulesetType, Types.CHRContext), object.getTarget(), methodWriter.getParameters()[0]);
            }
            methodWriter.return_(this.location, NoRepConstant.UNIT);
        }
        if (this.initConstraint != null) {
            IVal chrContext = w.apply(this.location, CREATE_CHR_CONTEXT, new IVal[0]);
            if (this.initializer != null) {
                w.apply(this.location, new JavaMethod(true, this.runtimeRulesetClassName, "initialize", (Type)Types.PROC, (Type)Types.UNIT, this.runtimeRulesetType, Types.CHRContext), object.getTarget(), chrContext);
            }
            IVal initFact = w.apply(this.location, this.initConstraint.constructor, w.apply(this.location, GENERATE_ID, chrContext));
            w.apply(this.location, this.initConstraint.addProcedure, this.runtimeRulesetVariable, chrContext, initFact);
            w.apply(this.location, ACTIVATE, chrContext, new IntegerConstant(Integer.MAX_VALUE));
            if (this.deinitializer != null) {
                w.apply(this.location, new JavaMethod(true, this.runtimeRulesetClassName, "deinitialize", (Type)Types.PROC, (Type)Types.UNIT, this.runtimeRulesetType, Types.CHRContext), object.getTarget(), chrContext);
            }
        }
        return this.runtimeRulesetVariable;
    }

    public void addRule(CHRRule rule) {
        this.rules.add(rule);
        rule.parentRuleset = this;
    }
}

