/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.diagram.stubs.DiagramResource;

public class ProfileEntryContributions
extends ResourceRead<Collection<Resource>> {
    protected ProfileEntryContributions(Resource runtimeDiagram) {
        super(runtimeDiagram);
    }

    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String indexURI = (String)graph.getPossibleRelatedValue(this.resource, DIA.RuntimeDiagram_HasModelURI);
        if (indexURI == null) {
            return Collections.emptyList();
        }
        Resource index = graph.getPossibleResource(indexURI);
        if (index == null) {
            return Collections.emptyList();
        }
        Instances query = (Instances)graph.adapt(DIA.ProfileEntryContribution, Instances.class);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource contribution : query.find(graph, index)) {
            for (Resource entry : graph.getObjects(contribution, DIA.ProfileEntryContribution_HasEntry)) {
                result.add(entry);
            }
        }
        return result;
    }
}

