/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import net.jpountz.util.ChecksumUtil;
import net.jpountz.util.NativeParameters;

public enum Native {

    private static boolean loaded = false;
    private static boolean failedToLoad = false;

    private static String arch() {
        return System.getProperty("os.arch");
    }

    private static OS os() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Linux")) {
            return OS.LINUX;
        }
        if (osName.contains("Mac")) {
            return OS.MAC;
        }
        if (osName.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (osName.contains("Solaris") || osName.contains("SunOS")) {
            return OS.SOLARIS;
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + osName);
    }

    private static String resourceName() {
        OS os = Native.os();
        String packagePrefix = Native.class.getPackage().getName().replace('.', '/');
        return "/" + packagePrefix + "/" + os.name + "/" + Native.arch() + "/liblz4-java." + os.libExtension;
    }

    public static synchronized boolean isLoaded() {
        return loaded;
    }

    public static boolean failedToLoad() {
        return failedToLoad;
    }

    public static synchronized void load() {
        Native.load(NativeParameters.extractionPath);
    }

    public static synchronized void load(Path extractionPath) {
        if (loaded) {
            return;
        }
        if (failedToLoad) {
            throw new UnsatisfiedLinkError("Native LZ4 dynamic library loading failed already. Not retrying.");
        }
        String resourceName = Native.resourceName();
        URL libraryUrl = Native.class.getResource(resourceName);
        if (libraryUrl == null) {
            throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + resourceName + ". Please try building from source.");
        }
        try {
            Path tempFile = null;
            boolean extract = true;
            try {
                Path out;
                if (extractionPath == null) {
                    out = tempFile = Files.createTempFile("liblz4-java", "." + Native.os().libExtension, new FileAttribute[0]);
                } else {
                    out = extractionPath.resolve("liblz4-java." + Native.os().libExtension);
                    if (Files.exists(out, new LinkOption[0])) {
                        byte[] targetHash;
                        byte[] sourceHash = ChecksumUtil.computeSum(libraryUrl);
                        boolean bl = extract = !Arrays.equals(sourceHash, targetHash = ChecksumUtil.computeSum(out));
                    }
                }
                if (extract) {
                    Native.copy(libraryUrl, out);
                }
                System.load(out.toString());
                loaded = true;
            }
            catch (Throwable throwable) {
                if (tempFile != null && Files.exists(tempFile, new LinkOption[0])) {
                    if (!loaded) {
                        Files.deleteIfExists(tempFile);
                    } else {
                        tempFile.toFile().deleteOnExit();
                    }
                }
                throw throwable;
            }
            if (tempFile != null && Files.exists(tempFile, new LinkOption[0])) {
                if (!loaded) {
                    Files.deleteIfExists(tempFile);
                } else {
                    tempFile.toFile().deleteOnExit();
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            failedToLoad = true;
            throw e;
        }
        catch (IOException iOException) {
            failedToLoad = true;
            throw new ExceptionInInitializerError("Cannot unpack liblz4-java");
        }
    }

    private static long copy(URL url, Path to) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = url.openStream();){
            return Files.copy(in, to, new CopyOption[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static enum OS {
        WINDOWS("win32", "dll"),
        LINUX("linux", "so"),
        MAC("darwin", "dylib"),
        SOLARIS("solaris", "so");

        public final String name;
        public final String libExtension;

        private OS(String name, String libExtension) {
            this.name = name;
            this.libExtension = libExtension;
        }
    }
}

