/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.function.Supplier;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeScriptDocumentProvider;
import org.simantics.modeling.ui.componentTypeEditor.Messages;
import org.simantics.modeling.ui.componentTypeEditor.SCLModuleEditor;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.ToolTipRequest;

public class ComponentTypeScriptEditor
extends SCLModuleEditor {
    private static final String[] EXECUTION_PHASES = new String[]{"pre-step", "step", "post-step", "analogAutomation", "binaryAutomation", "preparation"};
    private static final String[] EXECUTION_PHASE_LABELS = new String[]{Messages.ComponentTypeScriptEditor_ExecuteBeforeEachStep, Messages.ComponentTypeScriptEditor_ExecuteAtEachStep, Messages.ComponentTypeScriptEditor_ExecuteAfterEachStep, Messages.ComponentTypeScriptEditor_ExecuteAnalogAutomation, Messages.ComponentTypeScriptEditor_ExecuteBinaryAutomation, Messages.ComponentTypeScriptEditor_ExecuteDuringPreparation};

    @Override
    protected void preInitialize() {
        this.setDocumentProvider((IDocumentProvider)new ComponentTypeScriptDocumentProvider(this));
        PlatformUI.getWorkbench().getDisplay();
        SCLSourceViewerConfigurationNew sourceViewerConfiguration = new SCLSourceViewerConfigurationNew((ResourceManager)this.resourceManager);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)sourceViewerConfiguration);
    }

    @Override
    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return new ParametrizedRead<IResourceEditorInput, Boolean>(){

            public Read<Boolean> get(IResourceEditorInput parameter) {
                return Combinators.constant((Object)Boolean.TRUE);
            }
        };
    }

    @Override
    protected void updatePartName() {
        this.setPartName(this.getEditorInput().getName());
        Session session = Simantics.peekSession();
        if (session != null) {
            Supplier<Boolean> disposedCallback = this::isDisposed;
            session.asyncRequest((Read)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    Resource script = ComponentTypeScriptEditor.this.getResourceInput().getResource();
                    String name = (String)graph.getRelatedValue(script, L0.HasName);
                    Resource componentType = graph.getSingleObject(script, STR.ComponentType_hasScript_Inverse);
                    String ctName = (String)graph.getRelatedValue(componentType, L0.HasName);
                    return String.valueOf(ctName) + " " + name;
                }
            }, (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((ComponentTypeScriptEditor)this).setPartName(arg_0), disposedCallback));
            session.asyncRequest((Read)new ToolTipRequest(this.getSite().getId(), this.getResourceInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((ComponentTypeScriptEditor)this).setTitleToolTip(arg_0), disposedCallback));
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        final CCombo combo = new CCombo(parent, 2056);
        String[] stringArray = EXECUTION_PHASE_LABELS;
        int n = EXECUTION_PHASE_LABELS.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            combo.add(label);
            ++n2;
        }
        Session session = Simantics.peekSession();
        final Resource script = this.getResourceInput().getResource();
        if (session != null) {
            session.asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    final String type = (String)graph.getPossibleRelatedValue(script, STR.ComponentTypeScript_type);
                    if (type != null) {
                        combo.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                int i = 0;
                                while (i < EXECUTION_PHASES.length) {
                                    if (EXECUTION_PHASES[i].equals(type)) {
                                        combo.select(i);
                                        return;
                                    }
                                    ++i;
                                }
                            }
                        });
                    }
                }
            });
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final int id = combo.getSelectionIndex();
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                        String currentType = (String)graph.getPossibleRelatedValue(script, STR.ComponentTypeScript_type);
                        String newType = EXECUTION_PHASES[id];
                        if (!newType.equals(currentType)) {
                            graph.claimLiteral(script, STR.ComponentTypeScript_type, (Object)newType, (Binding)Bindings.STRING);
                        }
                    }
                });
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)combo);
        Composite editorComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editorComposite);
        editorComposite.setLayout((Layout)new FillLayout());
        super.createPartControl(editorComposite);
    }
}

