/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.icons;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleValue;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.AsyncRead;

public class GraphImageDescriptor
extends ImageDescriptor {
    private Resource resource;
    private long resourceId;
    private byte[] data;
    private int hash;

    public GraphImageDescriptor(ReadGraph graph, Resource resource) throws DatabaseException {
        this.resource = resource;
        this.resourceId = resource.getResourceId();
        this.data = this.getImageDataBytes((RequestProcessor)graph);
        this.hash = (Arrays.hashCode(this.data) * 31 + (int)(this.resourceId >>> 32)) * 31 + (int)this.resourceId;
    }

    private byte[] getImageDataBytes(RequestProcessor processor) throws DatabaseException {
        return (byte[])processor.syncRequest((AsyncRead)new PossibleValue(this.resource, (Binding)Bindings.BYTE_ARRAY));
    }

    private ImageData toImageData(byte[] data) throws SWTException {
        ImageData[] images = new ImageLoader().load((InputStream)new ByteArrayInputStream(data));
        if (images.length == 0) {
            SWT.error((int)40, null, (String)("No images found in image data of resource $" + this.resourceId));
        }
        return images[0];
    }

    public ImageData getImageData() {
        try {
            ImageData imageData = this.toImageData(this.data);
            return imageData;
        }
        catch (SWTException sWTException) {
            return null;
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.resource + "]";
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GraphImageDescriptor other = (GraphImageDescriptor)((Object)obj);
        if (!this.resource.equals(other.resource)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }
}

