/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events;

import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventHandlerStack;
import org.simantics.utils.datastructures.prioritystack.PriorityStack;
import org.simantics.utils.threads.CurrentThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class EventHandlerStack
extends PriorityStack<IEventHandler>
implements IEventHandlerStack {
    IThreadWorkQueue thread;

    public EventHandlerStack() {
        super(IEventHandler.class);
        this.thread = CurrentThread.getThreadAccess();
    }

    public EventHandlerStack(IThreadWorkQueue eventHandlingThread) {
        super(IEventHandler.class);
        this.thread = eventHandlingThread;
    }

    @Override
    public int getEventMask() {
        return EventTypes.AnyMask;
    }

    @Override
    public boolean handleEvent(final Event e) {
        final int eventType = EventTypes.toTypeMask(e);
        if (this.thread.currentThreadAccess()) {
            IEventHandler[] list = (IEventHandler[])this.toArray();
            int i = list.length - 1;
            while (i >= 0) {
                if (EventTypes.passes(list[i], eventType) && list[i].handleEvent(e)) {
                    return true;
                }
                --i;
            }
            return false;
        }
        final AtomicBoolean result = new AtomicBoolean(false);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                IEventHandler[] list = (IEventHandler[])EventHandlerStack.this.toArray();
                int i = list.length - 1;
                while (i >= 0) {
                    if (EventTypes.passes(list[i], eventType) && list[i].handleEvent(e)) {
                        result.set(true);
                        return;
                    }
                    --i;
                }
            }
        };
        ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)run);
        return result.get();
    }
}

