/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Map;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.graph.impl.LazyGraphLabeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphLabelerFactory
implements LabelerFactory {
    public Labeler create(PrimitiveQueryUpdater updater, final NodeContext context, BuiltinKeys.LabelerKey key) {
        assert (updater != null);
        assert (context != null);
        return new LazyGraphLabeler(updater, context, key){

            @Override
            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
                return GraphLabelerFactory.this.labels(graph, (Resource)context.getConstant(BuiltinKeys.INPUT));
            }

            @Override
            public int category(ReadGraph graph) throws DatabaseException {
                return GraphLabelerFactory.this.category(graph, (Resource)context.getConstant(BuiltinKeys.INPUT));
            }

            public String toString() {
                return GraphLabelerFactory.this.toString();
            }

            public Labeler.Modifier getModifier(GraphExplorer.ModificationContext modificationContext, String key) {
                return GraphLabelerFactory.this.getModifier(key);
            }

            @Override
            public Logger getLogger() {
                return LoggerFactory.getLogger(GraphLabelerFactory.class);
            }
        };
    }

    protected abstract Map<String, String> labels(ReadGraph var1, Resource var2) throws DatabaseException;

    protected int category(ReadGraph graph, Resource resource) throws DatabaseException {
        return 0;
    }

    protected Labeler.Modifier getModifier(String key) {
        return null;
    }
}

