/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.writer;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.writer.GraphWriter;
import org.simantics.layer0.utils.writer.GraphWriterPartial;

public class DirectGraphWriter
extends GraphWriterPartial {
    Resource current;
    WriteGraph wg;

    public DirectGraphWriter(WriteGraph graph) {
        super((ReadGraph)graph);
        this.wg = graph;
        this.current = null;
    }

    @Override
    public GraphWriter create() throws DatabaseException {
        this.current = this.wg.newResource();
        return this;
    }

    @Override
    public GraphWriter create(Resource type) throws DatabaseException {
        this.current = this.wg.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)this.wg);
        this.wg.claim(this.current, b.InstanceOf, null, type);
        return this;
    }

    @Override
    public Resource get() {
        return this.current;
    }

    @Override
    public GraphWriter handle(Resource s) {
        this.current = s;
        return this;
    }

    @Override
    public GraphWriter let(Resource p, Resource o) throws DatabaseException {
        if (this.current == null) {
            throw new RuntimeException("Should call create or handle before let.");
        }
        this.wg.claim(this.current, p, o);
        return this;
    }

    @Override
    public GraphWriter let(Resource p, Object value, Resource dataType) throws DatabaseException {
        if (this.current == null) {
            throw new RuntimeException("Should call create or handle before let.");
        }
        Resource temp = this.wg.newResource();
        this.wg.claim(temp, this.l0.InstanceOf, null, dataType);
        this.wg.claimValue(temp, value);
        this.wg.claim(this.current, p, temp);
        return this;
    }

    @Override
    public GraphWriter flush() throws DatabaseException {
        this.wg.flushCluster();
        return this;
    }

    @Override
    public GraphWriter createLiteral(Object value, Resource dataType) throws DatabaseException {
        this.current = this.wg.newResource();
        this.wg.claim(this.current, this.l0.InstanceOf, null, dataType);
        this.wg.claimValue(this.current, value);
        return this;
    }

    @Override
    public GraphWriter createInverse(Resource r) throws DatabaseException {
        this.current = this.wg.newResource();
        this.wg.claim(r, this.l0.InverseOf, this.current);
        return this;
    }
}

