/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.DataContainerRepresentation;
import org.simantics.db.layer0.util.ResourceCopyRepresentation;
import org.simantics.db.layer0.util.ResourceCutRepresentation;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.TGRepresentation;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.layer0.util.VariableRepresentation;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ClipboardUtils {
    public static String HINT_TARGET_RESOURCE = "HINT_TARGET_RESOURCE";

    public static <T> T accept(Set<SimanticsClipboard.Representation> set, IHintContext.Key key) throws DatabaseException {
        return ClipboardUtils.accept(set, key, Collections.emptyMap());
    }

    public static <T> T accept(Set<SimanticsClipboard.Representation> set, IHintContext.Key key, Map<String, Object> hints) throws DatabaseException {
        for (SimanticsClipboard.Representation r : set) {
            if (!r.getKey().equals(key)) continue;
            return r.getValue((RequestProcessor)SimanticsInternal.getSession(), hints);
        }
        return null;
    }

    public static <T> T accept(RequestProcessor processor, Set<SimanticsClipboard.Representation> set, IHintContext.Key key) throws DatabaseException {
        return ClipboardUtils.accept(processor, set, key, Collections.emptyMap());
    }

    public static <T> T accept(RequestProcessor processor, Set<SimanticsClipboard.Representation> set, IHintContext.Key key, Map<String, Object> hints) throws DatabaseException {
        for (SimanticsClipboard.Representation r : set) {
            if (!r.getKey().equals(key)) continue;
            return r.getValue(processor, hints);
        }
        return null;
    }

    public static <T> T accept(ReadGraph graph, Set<SimanticsClipboard.Representation> set, IHintContext.Key key) throws DatabaseException {
        return ClipboardUtils.accept(graph, set, key, Collections.emptyMap());
    }

    public static <T> T accept(ReadGraph graph, Set<SimanticsClipboard.Representation> set, IHintContext.Key key, Map<String, Object> hints) throws DatabaseException {
        for (SimanticsClipboard.Representation r : set) {
            if (!r.getKey().equals(key)) continue;
            return r.getValue((RequestProcessor)graph, hints);
        }
        return null;
    }

    public static <T> T acceptPossible(ReadGraph graph, IHintContext.Key key) throws DatabaseException {
        return ClipboardUtils.acceptPossible(graph, key, Collections.emptyMap());
    }

    public static <T> T acceptPossible(ReadGraph graph, IHintContext.Key key, Map<String, Object> hints) throws DatabaseException {
        Collection<T> results = ClipboardUtils.accept(graph, key, hints);
        if (results.size() == 1) {
            return results.iterator().next();
        }
        return null;
    }

    public static <T> Collection<T> accept(ReadGraph graph, IHintContext.Key key, Map<String, Object> hints) throws DatabaseException {
        ArrayList result = new ArrayList();
        for (Set<SimanticsClipboard.Representation> rs : SimanticsInternal.getClipboard().getContents()) {
            for (SimanticsClipboard.Representation r : rs) {
                if (!r.getKey().equals(key)) continue;
                result.add(r.getValue((RequestProcessor)graph, hints));
            }
        }
        return result;
    }

    public static SimanticsClipboard fileClipboard(String fileName) throws IOException {
        DataContainer container = DataContainers.readFile((File)new File(fileName));
        try {
            TGRepresentation tgRep = new TGRepresentation((TransferableGraph1)container.content.getValue(TransferableGraph1.BINDING));
            DataContainerRepresentation dcRep = new DataContainerRepresentation(container);
            return SimanticsClipboardImpl.make(dcRep, tgRep);
        }
        catch (AdaptException e) {
            Logger.defaultLogError((Throwable)e);
            return SimanticsClipboardImpl.EMPTY;
        }
    }

    public static SimanticsClipboard.Representation createTransferableGraph(Resource ... resources) {
        return new TGRepresentation(resources);
    }

    public static SimanticsClipboard.Representation createTransferableGraph(TransferableGraphConfiguration2 configuration) {
        return new TGRepresentation(configuration);
    }

    public static SimanticsClipboard.Representation createTransferableGraph(boolean ignoreVirtualResources, Resource ... resources) {
        return new TGRepresentation(ignoreVirtualResources, resources);
    }

    public static SimanticsClipboard.Representation createVariable(String uri) {
        return new VariableRepresentation(uri);
    }

    public static SimanticsClipboard.Representation createVariable(RequestProcessor processor, final Variable var) {
        try {
            return new VariableRepresentation((String)processor.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return var.getURI(graph);
                }
            }));
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public static SimanticsClipboard.Representation createCopyResources(Collection<Resource> resources) {
        return new ResourceCopyRepresentation(resources);
    }

    public static SimanticsClipboard.Representation createCutResources(Collection<Resource> resources) {
        return new ResourceCutRepresentation(resources);
    }

    public static PasteHandler pasteHandler(Resource resource) throws DatabaseException {
        return (PasteHandler)SimanticsInternal.sync((ReadInterface)new ResourceRead<PasteHandler>(resource){

            public PasteHandler perform(ReadGraph graph) throws DatabaseException {
                return (PasteHandler)graph.adapt(this.resource, PasteHandler.class);
            }
        });
    }
}

