package org.simantics.ui.workspace.tracker;

/**
 * Preference constants for the heap status.
 *
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public interface IWorkspaceSizeTrackerConstants {

	String P_NODE = "org.simantics.ui.workspace.tracker"; //$NON-NLS-1$

	/**
	 * Boolean preference key for whether or not to show the status bar workspace
	 * size monitor trim.
	 */
	String PREF_SHOW_MONITOR = "WorkspaceSizeTracker.showMonitor"; //$NON-NLS-1$

	/**
	 * Preference key for the update interval (value in milliseconds).
	 */
	String PREF_UPDATE_INTERVAL = "WorkspaceSizeTracker.updateInterval"; //$NON-NLS-1$

	/**
	 * Boolean preference key for whether to highlight to the user when low on disk space.
	 */
	String PREF_HIGHLIGHT_LOW_SPACE = "WorkspaceSizeTracker.highlightLowSpace"; //$NON-NLS-1$

	/**
	 * Preference key for the low space threshold (value in megabytes).
	 */
	String PREF_LOW_SPACE_THRESHOLD = "WorkspaceSizeTracker.lowSpaceThreshold"; //$NON-NLS-1$

	boolean DEFAULT_SHOW_MONITOR        = true;
	int     DEFAULT_UPDATE_INTERVAL     = 1000;
	boolean DEFAULT_HIGHLIGHT_LOW_SPACE = true;
	long    DEFAULT_LOW_SPACE_THRESHOLD = 500L;

}
