/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.team.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.TeamSupport;
import org.simantics.team.Activator;
import org.simantics.team.Utils;
import org.simantics.team.ui.CommentDialog;
import org.simantics.ui.workbench.handler.AbstractPreferenceHandler;

public class StagingOutHandler extends AbstractPreferenceHandler {
    public StagingOutHandler() {
        super(Activator.getDefault());
    }
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        System.out.println("push and exit");
//        ISelection sel = HandlerUtil.getCurrentSelection(event);
//        IStructuredSelection ss = StructuredSelection.EMPTY;
//        if (sel instanceof IStructuredSelection)
//            ss = (IStructuredSelection) sel;
        try {
            Session session = Simantics.getSession();
            TeamSupport ts = session.getService(TeamSupport.class);
            final CommentDialog.Data data = new CommentDialog.Data("Staging Comment");
            if (!CommentDialog.openCommentDialog(data))
                return null; // User cancelled operation.
            ts.commit(data.comment, Utils.getTeamFolder(), false);
        } catch (DatabaseException e) {
            //throw new ExecutionException("Failed to publish.", e);
            PlatformUI.getWorkbench().close();
            System.exit(1);
        }
        PlatformUI.getWorkbench().close();
        System.exit(0);
        return null;
    }
}
