/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.synchronization;

import java.util.Collection;
import java.util.Map;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.SpreadsheetStyle;
import org.simantics.spreadsheet.graph.synchronization.SheetLineComponent;
import org.simantics.structural.synchronization.base.CommandBuilder;
import org.simantics.structural.synchronization.base.ModuleUpdateContext;
import org.simantics.structural.synchronization.base.ModuleUpdaterBase;
import org.simantics.structural.synchronization.base.PropertyUpdateRule;
import org.simantics.structural.synchronization.utils.Solver;

public class StyleUpdater
extends ModuleUpdaterBase<SheetLineComponent> {
    public StyleUpdater(String moduleType) {
        super(moduleType);
        this.addPropertyUpdateRule(new ForegroundUpdateRule());
        this.addPropertyUpdateRule(new BackgroundUpdateRule());
        this.addPropertyUpdateRule(new FontUpdateRule());
        this.addPropertyUpdateRule(new AlignUpdateRule());
        this.addPropertyUpdateRule(new FormatStringUpdateRule());
        this.addPropertyUpdateRule(new FormatIndexUpdateRule());
        this.addPropertyUpdateRule(new BorderUpdateRule());
        this.addPropertyUpdateRule(new LockedUpdateRule());
        this.addPropertyUpdateRule(new ColumnSpanUpdateRule());
        this.addPropertyUpdateRule(new RowSpanUpdateRule());
    }

    public CommandBuilder createAddCommandBuilder(String name) {
        return new StyleCommandBuilder(name, false);
    }

    public CommandBuilder createUpdateCommandBuilder(String name) {
        return new StyleCommandBuilder(name, true);
    }

    private static class AlignUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private AlignUpdateRule() {
        }

        public String getPropertyName() {
            return "align";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            int align;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.align = align = ((Integer)value.getValue()).intValue();
        }
    }

    private static class BackgroundUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private BackgroundUpdateRule() {
        }

        public String getPropertyName() {
            return "background";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            RGB.Integer color;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.background = color = (RGB.Integer)value.getValue();
        }
    }

    private static class BorderUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private BorderUpdateRule() {
        }

        public String getPropertyName() {
            return "border";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            int border;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.border = border = ((Integer)value.getValue()).intValue();
        }
    }

    private static class ColumnSpanUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private ColumnSpanUpdateRule() {
        }

        public String getPropertyName() {
            return "columnSpan";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            int columnSpan;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.columnSpan = columnSpan = ((Integer)value.getValue()).intValue();
        }
    }

    private static class FontUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private FontUpdateRule() {
        }

        public String getPropertyName() {
            return "font";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            Font font;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.font = font = (Font)value.getValue();
        }
    }

    private static class ForegroundUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private ForegroundUpdateRule() {
        }

        public String getPropertyName() {
            return "foreground";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            RGB.Integer color;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.foreground = color = (RGB.Integer)value.getValue();
        }
    }

    private static class FormatIndexUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private FormatIndexUpdateRule() {
        }

        public String getPropertyName() {
            return "formatIndex";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            int index;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.formatIndex = index = ((Integer)value.getValue()).intValue();
        }
    }

    private static class FormatStringUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private FormatStringUpdateRule() {
        }

        public String getPropertyName() {
            return "formatString";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            String formatString;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.formatString = formatString = (String)value.getValue();
        }
    }

    private static class LockedUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private LockedUpdateRule() {
        }

        public String getPropertyName() {
            return "locked";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            boolean locked;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.locked = locked = ((Boolean)value.getValue()).booleanValue();
        }
    }

    private static class RowSpanUpdateRule
    implements PropertyUpdateRule<SheetLineComponent> {
        private RowSpanUpdateRule() {
        }

        public String getPropertyName() {
            return "rowSpan";
        }

        public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating, Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {
            int rowSpan;
            StyleCommandBuilder builder = (StyleCommandBuilder)context.getConcreteCommand();
            builder.rowSpan = rowSpan = ((Integer)value.getValue()).intValue();
        }
    }

    private static class StyleCommandBuilder
    implements CommandBuilder {
        protected int rowSpan;
        protected int columnSpan;
        protected int border;
        protected boolean locked;
        protected int formatIndex;
        protected String formatString;
        protected RGB.Integer background;
        protected RGB.Integer foreground;
        protected Font font;
        protected int align;
        private boolean update;
        private String name;

        public StyleCommandBuilder(String name, boolean update) {
            this.name = name.split("/")[1];
            this.update = update;
        }

        public void apply(Solver solver) {
            SpreadsheetStyle style;
            SpreadsheetBook book = (SpreadsheetBook)solver.getConcreteSolver();
            if (book.getStyle((style = SpreadsheetStyle.newInstace().name(this.name).align(this.align).font(this.font).background(this.background).foreground(this.foreground).border(this.border).locked(this.locked).rowSpan(this.rowSpan).columnSpan(this.columnSpan).formatIndex((short)this.formatIndex).formatString(this.formatString).build()).getStyleId()) == null) {
                book.addStyle(style);
            }
        }

        public <T> T getConcrete() {
            return (T)this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("StyleCommandBuilder for ").append(this.name).append(" [background=").append(this.background).append(", foregroung=").append(this.foreground).append(", font=").append(this.font).append(", align=").append(this.align).append("]");
            return sb.toString();
        }
    }
}

