/*******************************************************************************
 * Copyright (c) 2007, 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - added step end time and mode
 *******************************************************************************/
package org.simantics.simulation.ui.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.simantics.utils.format.TimeFormat;

/**
 * Constant definitions for plug-in preferences
 */
public final class SimulationPreferences {

    public static final String                P_SIMULATION_STEP_DURATION       = "simulation.step.duration";
    public static final String                P_SIMULATION_STEP_END_TIME       = "simulation.step.endTime";
    public static final String                P_SIMULATION_STEP_MODE           = "simulation.step.mode";

    public static enum StepMode {
        DURATION,
        END_TIME;

        public static StepMode fromInt(int stepMode) {
            switch (stepMode) {
            case 1: return END_TIME;
            default: return DURATION;
            }
        }
    }

    public static final double                DEFAULT_SIMULATION_STEP_DURATION = 0.1;
    public static final double                DEFAULT_SIMULATION_STEP_END_TIME = 0;
    public static final StepMode              DEFAULT_SIMULATION_STEP_MODE     = StepMode.DURATION;

    public static final SimulationPreferences DEFAULT_PREFS
        = new SimulationPreferences(null,
                DEFAULT_SIMULATION_STEP_DURATION,
                DEFAULT_SIMULATION_STEP_END_TIME,
                DEFAULT_SIMULATION_STEP_MODE);

    public final IEclipsePreferences          prefs;
    public final double                       stepDuration;
    public final double                       stepEndTime;
    public final StepMode                     stepMode;

    public SimulationPreferences(double stepDuration, double stepEndTime, StepMode stepMode) {
        this(null, stepDuration, stepEndTime, stepMode);
    }

    public SimulationPreferences(IEclipsePreferences prefs, double stepDuration, double stepEndTime, StepMode stepMode) {
        this.prefs = prefs;
        this.stepDuration = stepDuration;
        this.stepEndTime = stepEndTime;
        this.stepMode = stepMode;
    }

    public SimulationPreferences withDuration(double duration) {
        return new SimulationPreferences(duration, stepEndTime, stepMode);
    }

    public SimulationPreferences withEndTime(double endTime) {
        return new SimulationPreferences(stepDuration, endTime, stepMode);
    }

    public SimulationPreferences withStepMode(StepMode mode) {
        return new SimulationPreferences(stepDuration, stepEndTime, mode);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName()
                + "[step duration=" + stepDuration
                + ", step end time=" + stepEndTime
                + ", step mode=" + stepMode
                + "]";
    }

}
