/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers;

import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.simantics.simulation.experiment.ExperimentUtil;
import org.simantics.simulation.ui.Activator;

public class Run extends AbstractHandler implements IElementUpdater {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICommandService service =
            (ICommandService) PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.simantics.simulation.ui.run");
        State state = command.getState("org.simantics.simulation.ui.run.state");

        ExperimentUtil.simulate(!(Boolean)state.getValue());
        return null;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public void updateElement(UIElement element, Map parameters) {
        ICommandService commandService =
            (ICommandService) PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.simantics.simulation.ui.run");
        boolean checked = (Boolean) command.getState("org.simantics.simulation.ui.run.state").getValue();
        element.setChecked(checked);
        if (checked) {
            element.setIcon(Activator.PAUSE_ICON);
            element.setHoverIcon(Activator.PAUSE_HOVER_ICON);
            element.setTooltip("Pause");
        } else {
            element.setIcon(Activator.PLAY_ICON);
            element.setHoverIcon(Activator.PLAY_HOVER_ICON);
            element.setTooltip("Run");
        }
    }

}
