/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperimentListener;

public class ExperimentListener implements IExperimentListener {

    IContextActivation contextActivation;

    @Override
    public void stateChanged(final ExperimentState state) {
        
        if(!PlatformUI.isWorkbenchRunning()) return;   
        
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {

            @Override
            public void run() {
            	ICommandService service = 
            		(ICommandService) PlatformUI.getWorkbench().getService(ICommandService.class); 
            	Command command = service.getCommand("org.simantics.simulation.ui.run"); 
            	State buttonState = command.getState("org.simantics.simulation.ui.run.state"); 
            	buttonState.setValue(!(Boolean) buttonState.getValue()); 
            	            	
            	switch(state) {
                case RUNNING:
                	//System.out.println("RUNNING");
                	buttonState.setValue(true); 
                    break;
                case STOPPED:
                default:
                	//System.out.println("STOPPED");
                	buttonState.setValue(false);
                    break;
                }
            	service.refreshElements(command.getId(), null); 
            	
                /*IContextService contextService =
                    (IContextService)PlatformUI.getWorkbench()
                    .getActiveWorkbenchWindow().getService(IContextService.class);
                if(contextActivation != null)                                     
                    contextService.deactivateContext(contextActivation);
                switch(state) {
                case RUNNING:
                    contextActivation = contextService.activateContext("org.simantics.simulation.ui.experimentRunning");
                    break;
                case STOPPED:
                    contextActivation = contextService.activateContext("org.simantics.simulation.ui.experimentStopped");
                    break;
                default:
                    contextActivation = null;
                    break;

                } */               
            }
            
        });
    }

}
