/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procedure;

/**
 * 
 * 
 * 
 * @see AsyncProcedure
 * @see AsyncMultiProcedure
 * @see SetProcedure
 * @see Procedure
 * @see MultiProcedure
 */
public interface ListenerBase {
    
	/**
	 * Informs the database client of the liveness of this procedure. After a
	 * procedure says that it is disposed, it will be detached from listening to
	 * request changes and allow the system to discard the procedure references
	 * from the request.
	 * 
	 * <p>
	 * This return value can be either <code>true</code> or change from
	 * <code>false</code> to <code>true</code>, it must never change from
	 * <code>true</code> to <code>false</code>.
	 * </p>
	 * 
	 * @return
	 */
	boolean isDisposed();

}
