/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteOnly;

/**
 * An interface that VirtualGraphSource can use to manipulate the transient virtual graph.
 * 
 * @author Antti Villberg
 */
public interface VirtualGraphContext {
    
	/**
	 * Creates a new transient resource.
	 * @return
	 */
    int newResource(boolean lazy);
    
    void finish(int resource);
    
    /**
     * Converts a transient or persistent resource to an integer id.
     * @param resource
     * @return
     */
    int getIndex(Resource resource);
    /**
     * Converts an integer id to a resource.
     * @param index
     * @return
     */
    Resource getResource(int index);
    @Deprecated
    void initialise(Write write);
    void postModification(AsyncRequestProcessor processor, WriteOnly request);
    /**
     * Updates previously given result to getStatements.
     * @param resource
     * @param statements
     */
    void updateStatements(int resource, int[] statements);
    /**
     * Updates previously given result to getValue.
     * @param resource
     * @param value
     * @param binding
     */
    void updateValue(int resource, Object value, Binding binding);
//    /**
//     * Makes a request to persistent graph in getStatements of getValue
//     * and updates the results.
//     * @param <T>
//     * @param read
//     * @param procedure
//     */
//    <T> void pending(AsyncRead<T> read, Procedure<T> procedure);

}
