/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;



final public class RelationInfo {
    
    public static final RelationInfo[] NONE = new RelationInfo[0];
    public final int predicate;
    public final boolean isFunctional;
    public final boolean isFinal;
    public final boolean isAsserted;
    
    public RelationInfo(final int predicate, final boolean isFunctional, final boolean isFinal, final boolean isAsserted) {
        this.predicate = predicate;
        this.isFunctional = isFunctional;
        this.isFinal = isFinal;
        this.isAsserted = isAsserted;
    }
    
    @Override
    public String toString() {
    	return "RelationInfo[predicate=" + predicate + ", isFunctional=" + isFunctional + ", isFinal=" + isFinal + ", isAsserted=" + isAsserted + "]";
    }
    
    @Override
    public int hashCode() {
        return 31 * predicate;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (RelationInfo.class != object.getClass())
            return false;
        RelationInfo r = (RelationInfo)object;
        return r.predicate == predicate && r.isFinal == isFinal && r.isFunctional == isFunctional;
    }
    
    
}
