package org.simantics.db;

import org.simantics.databoard.binding.Binding;

public class DevelopmentEvents {

	public interface WriteGraphEvent {
		
		VirtualGraph getVirtualGraph();
		
	}
	
	public interface ClaimEvent extends WriteGraphEvent {
		
		Resource getSubject();
		Resource getPredicate();
		Resource getObject();
		
	}

	public interface DenyEvent extends WriteGraphEvent {
		
		Resource getSubject();
		Resource getPredicate();
		Resource getObject();
		
	}
	
	public interface ClaimValueEvent extends WriteGraphEvent {
		
		Resource getSubject();
		Object getValue();
		Binding getBinding();
		
	}

	public interface DenyValueEvent extends WriteGraphEvent {
		
		Resource getSubject();
		Object getValue();
		
	}
	
}
