/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.Session;
import org.simantics.db.common.SessionThread;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryThread
extends Thread
implements SessionThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryThread.class);
    boolean disposed = false;
    private Semaphore exited = new Semaphore(0);
    final int index;
    private Session session;
    private QuerySupport querySupport;
    private final QueryProcessor processor;
    private final ArrayList<QueryProcessor.SessionTask> tasks = new ArrayList();
    private final Object querySupportLock;
    private final int THREADS;
    private final AtomicInteger sleepers;
    private final QueryProcessor.ThreadState[] threadStates;
    private QueryProcessor.SessionTask currentTask;

    public QueryThread(Session session, QueryProcessor processor, int index, String name) {
        super(QueryProcessor.QueryThreadGroup, null, name);
        this.session = session;
        this.processor = processor;
        this.index = index;
        this.querySupportLock = processor.querySupportLock;
        this.THREADS = processor.THREADS;
        this.sleepers = processor.sleepers;
        this.querySupport = processor.querySupport;
        this.threadStates = processor.threadStates;
    }

    synchronized void dispose() {
        this.disposed = true;
        try {
            boolean acquired = this.exited.tryAcquire(60L, TimeUnit.SECONDS);
            if (!acquired) {
                LOGGER.error("Could not safely dispose query thread {} - we were processing task {} and still have tasks to do {}", new Object[]{this.index, this.currentTask.graph != null ? String.valueOf(this.currentTask) : "SessionTask with null graph", this.tasks.size()});
                this.interrupt();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("dispose was interrupted", (Throwable)e);
        }
        this.session = null;
        this.querySupport = null;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    public Session getSession() {
        return this.session;
    }

    private boolean pumpTask() {
        if (!this.processor.freeScheduling.isEmpty()) {
            this.tasks.add(this.processor.freeScheduling.removeFirst());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ArrayList<QueryProcessor.SessionTask> newTasks(boolean doWait, ArrayList<QueryProcessor.SessionTask> tasks) {
        try {
            while (true) {
                if (!tasks.isEmpty()) {
                    return tasks;
                }
                if (!doWait) {
                    return null;
                }
                Object object = this.querySupportLock;
                synchronized (object) {
                    if (this.pumpTask()) {
                        return tasks;
                    }
                    if (this.sleepers.incrementAndGet() == this.THREADS) {
                        this.sleepers.decrementAndGet();
                        if (this.querySupport == null) {
                            System.err.println("null qs");
                        }
                        this.querySupport.ceased(this.index);
                        if (this.pumpTask()) {
                            return tasks;
                        }
                        this.sleepers.incrementAndGet();
                    }
                }
                if (this.isDisposed()) {
                    this.threadStates[this.index] = QueryProcessor.ThreadState.DISPOSED;
                    return null;
                }
                this.threadStates[this.index] = QueryProcessor.ThreadState.SLEEP;
                object = this.querySupportLock;
                synchronized (object) {
                    this.querySupportLock.wait(100L);
                }
                this.sleepers.decrementAndGet();
                if (this.isDisposed()) {
                    this.threadStates[this.index] = QueryProcessor.ThreadState.DISPOSED;
                    return null;
                }
                this.threadStates[this.index] = QueryProcessor.ThreadState.RUN;
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Query handling (newTasks) was interrupted", (Throwable)e);
            throw new RuntimeException("Querying was interrupted.", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean runSynchronized() {
        didExecute = false;
        if (!this.tasks.isEmpty() || (finished = this.newTasks(false, this.tasks)) != null) ** GOTO lbl8
        return didExecute;
lbl-1000:
        // 1 sources

        {
            t = this.currentTask = this.tasks.remove(this.tasks.size() - 1);
            t.run(this.index);
            didExecute = true;
            this.currentTask = null;
lbl8:
            // 2 sources

            ** while (!this.tasks.isEmpty())
        }
lbl9:
        // 1 sources

        return didExecute;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

