/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.map.hash.THashMap;
import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.RelationInfo;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.AssertedPredicates;
import org.simantics.db.impl.query.AssertedStatements;
import org.simantics.db.impl.query.AsyncMultiReadEntry;
import org.simantics.db.impl.query.AsyncReadEntry;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.ChildMap;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.DirectSuperRelations;
import org.simantics.db.impl.query.DoubleKeyQueryHashMap;
import org.simantics.db.impl.query.ExternalReadEntry;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.ListenerEntry;
import org.simantics.db.impl.query.MultiReadEntry;
import org.simantics.db.impl.query.Objects;
import org.simantics.db.impl.query.OrderedSet;
import org.simantics.db.impl.query.Predicates;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.QueryCacheBase;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.ReadEntry;
import org.simantics.db.impl.query.RelationInfoQuery;
import org.simantics.db.impl.query.StableHashMap;
import org.simantics.db.impl.query.Statements;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.impl.query.TypeHierarchy;
import org.simantics.db.impl.query.Types;
import org.simantics.db.impl.query.URIToResource;
import org.simantics.db.impl.query.UnaryQueryHashMap;
import org.simantics.db.impl.query.ValueQuery;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;

public class QueryCache
extends QueryCacheBase {
    private static final boolean SINGLE = false;

    public QueryCache(QuerySupport querySupport, int threads) {
        super(querySupport, threads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Objects getOrCreateObjects(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        Objects existing = null;
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.objectsMap;
        synchronized (doubleKeyQueryHashMap) {
            existing = (Objects)this.objectsMap.get(r1, r2);
            if (existing == null) {
                existing = new Objects(r1, r2);
                existing.setPending(this.querySupport);
                this.objectsMap.put(QueryCache.keyR2(r1, r2), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Objects entry) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.objectsMap;
        synchronized (doubleKeyQueryHashMap) {
            this.objectsMap.remove(entry.id);
        }
    }

    public static void runnerObjects(ReadGraphImpl graph, int r1, int r2, CacheEntry parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r1, r2)) {
            Objects.computeForEach(graph, r1, r2, null, procedure);
            return;
        }
        Objects entry = cache.getOrCreateObjects(graph, r1, r2);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureObjects;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            Objects.computeForEach(graph, r1, r2, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Objects peekObjects(int r1, int r2) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.objectsMap;
        synchronized (doubleKeyQueryHashMap) {
            return (Objects)this.objectsMap.get(r1, r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Statements getOrCreateStatements(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        Statements existing = null;
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.statementsMap;
        synchronized (doubleKeyQueryHashMap) {
            existing = (Statements)this.statementsMap.get(r1, r2);
            if (existing == null) {
                existing = new Statements(r1, r2);
                existing.setPending(this.querySupport);
                this.statementsMap.put(QueryCache.keyR2(r1, r2), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Statements entry) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.statementsMap;
        synchronized (doubleKeyQueryHashMap) {
            this.statementsMap.remove(entry.id);
        }
    }

    public static void runnerStatements(ReadGraphImpl graph, int r1, int r2, CacheEntry parent, ListenerBase listener, TripleIntProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r1, r2)) {
            Statements.computeForEach(graph, r1, r2, null, procedure);
            return;
        }
        Statements entry = cache.getOrCreateStatements(graph, r1, r2);
        TripleIntProcedure procedure_ = procedure != null ? procedure : emptyProcedureStatements;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            Statements.computeForEach(graph, r1, r2, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statements peekStatements(int r1, int r2) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.statementsMap;
        synchronized (doubleKeyQueryHashMap) {
            return (Statements)this.statementsMap.get(r1, r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectObjects getOrCreateDirectObjects(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        DirectObjects existing = null;
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.directObjectsMap;
        synchronized (doubleKeyQueryHashMap) {
            existing = (DirectObjects)this.directObjectsMap.get(r1, r2);
            if (existing == null) {
                existing = new DirectObjects(r1, r2);
                existing.setPending(this.querySupport);
                this.directObjectsMap.put(QueryCache.keyR2(r1, r2), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectObjects entry) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.directObjectsMap;
        synchronized (doubleKeyQueryHashMap) {
            this.directObjectsMap.remove(entry.id);
        }
    }

    public static void runnerDirectObjects(ReadGraphImpl graph, int r1, int r2, CacheEntry parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r1, r2)) {
            DirectObjects.computeForEach(graph, r1, r2, null, procedure);
            return;
        }
        DirectObjects entry = cache.getOrCreateDirectObjects(graph, r1, r2);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureDirectObjects;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            DirectObjects.computeForEach(graph, r1, r2, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectObjects peekDirectObjects(int r1, int r2) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.directObjectsMap;
        synchronized (doubleKeyQueryHashMap) {
            return (DirectObjects)this.directObjectsMap.get(r1, r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelationInfoQuery getOrCreateRelationInfoQuery(ReadGraphImpl graph, int r) throws DatabaseException {
        RelationInfoQuery existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.relationInfoQueryMap;
        synchronized (unaryQueryHashMap) {
            existing = (RelationInfoQuery)this.relationInfoQueryMap.get(r);
            if (existing == null) {
                existing = new RelationInfoQuery(r);
                existing.setPending(this.querySupport);
                this.relationInfoQueryMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(RelationInfoQuery entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.relationInfoQueryMap;
        synchronized (unaryQueryHashMap) {
            this.relationInfoQueryMap.remove(entry.id);
        }
    }

    public static void runnerRelationInfoQuery(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<RelationInfo> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            RelationInfoQuery.computeForEach(graph, r, null, procedure);
            return;
        }
        RelationInfoQuery entry = cache.getOrCreateRelationInfoQuery(graph, r);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedureRelationInfoQuery;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            RelationInfoQuery.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelationInfoQuery peekRelationInfoQuery(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.relationInfoQueryMap;
        synchronized (unaryQueryHashMap) {
            return (RelationInfoQuery)this.relationInfoQueryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URIToResource getOrCreateURIToResource(ReadGraphImpl graph, String id) throws DatabaseException {
        URIToResource existing = null;
        THashMap tHashMap = this.uRIToResourceMap;
        synchronized (tHashMap) {
            existing = (URIToResource)this.uRIToResourceMap.get((Object)id);
            if (existing == null) {
                existing = new URIToResource(id);
                existing.setPending(this.querySupport);
                this.uRIToResourceMap.put((Object)QueryCache.keyID(id), (Object)existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(URIToResource entry) {
        THashMap tHashMap = this.uRIToResourceMap;
        synchronized (tHashMap) {
            this.uRIToResourceMap.remove((Object)entry.id);
        }
    }

    public static void runnerURIToResource(ReadGraphImpl graph, String id, CacheEntry parent, ListenerBase listener, InternalProcedure<Integer> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, id)) {
            URIToResource.computeForEach(graph, id, null, procedure);
            return;
        }
        URIToResource entry = cache.getOrCreateURIToResource(graph, id);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedureURIToResource;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            URIToResource.computeForEach(graph, id, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URIToResource peekURIToResource(String id) {
        THashMap tHashMap = this.uRIToResourceMap;
        synchronized (tHashMap) {
            return (URIToResource)this.uRIToResourceMap.get((Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueQuery getOrCreateValueQuery(ReadGraphImpl graph, int r) throws DatabaseException {
        ValueQuery existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.valueQueryMap;
        synchronized (unaryQueryHashMap) {
            existing = (ValueQuery)this.valueQueryMap.get(r);
            if (existing == null) {
                existing = new ValueQuery(r);
                existing.setPending(this.querySupport);
                this.valueQueryMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ValueQuery entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.valueQueryMap;
        synchronized (unaryQueryHashMap) {
            this.valueQueryMap.remove(entry.id);
        }
    }

    public static void runnerValueQuery(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<byte[]> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            ValueQuery.computeForEach(graph, r, null, procedure);
            return;
        }
        ValueQuery entry = cache.getOrCreateValueQuery(graph, r);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedureValueQuery;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            ValueQuery.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueQuery peekValueQuery(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.valueQueryMap;
        synchronized (unaryQueryHashMap) {
            return (ValueQuery)this.valueQueryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrderedSet getOrCreateOrderedSet(ReadGraphImpl graph, int r) throws DatabaseException {
        OrderedSet existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.orderedSetMap;
        synchronized (unaryQueryHashMap) {
            existing = (OrderedSet)this.orderedSetMap.get(r);
            if (existing == null) {
                existing = new OrderedSet(r);
                existing.setPending(this.querySupport);
                this.orderedSetMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(OrderedSet entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.orderedSetMap;
        synchronized (unaryQueryHashMap) {
            this.orderedSetMap.remove(entry.id);
        }
    }

    public static void runnerOrderedSet(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            OrderedSet.computeForEach(graph, r, null, procedure);
            return;
        }
        OrderedSet entry = cache.getOrCreateOrderedSet(graph, r);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureOrderedSet;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            OrderedSet.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderedSet peekOrderedSet(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.orderedSetMap;
        synchronized (unaryQueryHashMap) {
            return (OrderedSet)this.orderedSetMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrincipalTypes getOrCreatePrincipalTypes(ReadGraphImpl graph, int r) throws DatabaseException {
        PrincipalTypes existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.principalTypesMap;
        synchronized (unaryQueryHashMap) {
            existing = (PrincipalTypes)this.principalTypesMap.get(r);
            if (existing == null) {
                existing = new PrincipalTypes(r);
                existing.setPending(this.querySupport);
                this.principalTypesMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(PrincipalTypes entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.principalTypesMap;
        synchronized (unaryQueryHashMap) {
            this.principalTypesMap.remove(entry.id);
        }
    }

    public static void runnerPrincipalTypes(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            PrincipalTypes.computeForEach(graph, r, null, procedure);
            return;
        }
        PrincipalTypes entry = cache.getOrCreatePrincipalTypes(graph, r);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedurePrincipalTypes;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            PrincipalTypes.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalTypes peekPrincipalTypes(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.principalTypesMap;
        synchronized (unaryQueryHashMap) {
            return (PrincipalTypes)this.principalTypesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectPredicates getOrCreateDirectPredicates(ReadGraphImpl graph, int r) throws DatabaseException {
        DirectPredicates existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.directPredicatesMap;
        synchronized (unaryQueryHashMap) {
            existing = (DirectPredicates)this.directPredicatesMap.get(r);
            if (existing == null) {
                existing = new DirectPredicates(r);
                existing.setPending(this.querySupport);
                this.directPredicatesMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectPredicates entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.directPredicatesMap;
        synchronized (unaryQueryHashMap) {
            this.directPredicatesMap.remove(entry.id);
        }
    }

    public static void runnerDirectPredicates(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            DirectPredicates.computeForEach(graph, r, null, procedure);
            return;
        }
        DirectPredicates entry = cache.getOrCreateDirectPredicates(graph, r);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedureDirectPredicates;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            DirectPredicates.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectPredicates peekDirectPredicates(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.directPredicatesMap;
        synchronized (unaryQueryHashMap) {
            return (DirectPredicates)this.directPredicatesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Predicates getOrCreatePredicates(ReadGraphImpl graph, int r) throws DatabaseException {
        Predicates existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.predicatesMap;
        synchronized (unaryQueryHashMap) {
            existing = (Predicates)this.predicatesMap.get(r);
            if (existing == null) {
                existing = new Predicates(r);
                existing.setPending(this.querySupport);
                this.predicatesMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Predicates entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.predicatesMap;
        synchronized (unaryQueryHashMap) {
            this.predicatesMap.remove(entry.id);
        }
    }

    public static void runnerPredicates(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            Predicates.computeForEach(graph, r, null, procedure);
            return;
        }
        Predicates entry = cache.getOrCreatePredicates(graph, r);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedurePredicates;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            Predicates.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Predicates peekPredicates(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.predicatesMap;
        synchronized (unaryQueryHashMap) {
            return (Predicates)this.predicatesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReadEntry getOrCreateReadEntry(ReadGraphImpl graph, Read<?> r, boolean needsToBlock) throws DatabaseException {
        ReadEntry existing = null;
        StableHashMap stableHashMap = this.readEntryMap;
        synchronized (stableHashMap) {
            existing = (ReadEntry)this.readEntryMap.get(r);
            if (existing == null) {
                existing = new ReadEntry(r);
                existing.setPending(this.querySupport);
                this.readEntryMap.put(QueryCache.id(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            if (needsToBlock) {
                QueryCache.waitPending(graph, existing);
            } else {
                return null;
            }
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ReadEntry entry) {
        StableHashMap stableHashMap = this.readEntryMap;
        synchronized (stableHashMap) {
            this.readEntryMap.remove(entry.id);
        }
    }

    public static Object runnerReadEntry(ReadGraphImpl graph, final Read<?> r, final CacheEntry parent, final ListenerBase listener, final AsyncProcedure procedure, final boolean needsToBlock) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            return ReadEntry.computeForEach(graph, r, null, procedure, needsToBlock);
        }
        ReadEntry entry = cache.getOrCreateReadEntry(graph, r, needsToBlock);
        if (entry == null) {
            graph.processor.schedule(new QueryProcessor.SessionTask(graph){

                @Override
                public void run0(int thread) {
                    try {
                        QueryCache.runnerReadEntry(this.graph, r, parent, listener, procedure, needsToBlock);
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            });
            return null;
        }
        AsyncProcedure procedure_ = procedure != null ? procedure : emptyProcedureReadEntry;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            return entry.performFromCache(graph, procedure_);
        }
        assert (entry.isPending());
        Object result = ReadEntry.computeForEach(graph, r, entry, procedure_, needsToBlock);
        if (listenerEntry != null) {
            cache.primeListenerEntry(listenerEntry, entry.getResult());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadEntry peekReadEntry(Read<?> r) {
        StableHashMap stableHashMap = this.readEntryMap;
        synchronized (stableHashMap) {
            return (ReadEntry)this.readEntryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncReadEntry getOrCreateAsyncReadEntry(ReadGraphImpl graph, AsyncRead<?> r, boolean needsToBlock) throws DatabaseException {
        AsyncReadEntry existing = null;
        StableHashMap stableHashMap = this.asyncReadEntryMap;
        synchronized (stableHashMap) {
            existing = (AsyncReadEntry)this.asyncReadEntryMap.get(r);
            if (existing == null) {
                existing = new AsyncReadEntry(r);
                existing.setPending(this.querySupport);
                this.asyncReadEntryMap.put(QueryCache.id(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            if (needsToBlock) {
                QueryCache.waitPending(graph, existing);
            } else {
                return null;
            }
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(AsyncReadEntry entry) {
        StableHashMap stableHashMap = this.asyncReadEntryMap;
        synchronized (stableHashMap) {
            this.asyncReadEntryMap.remove(entry.id);
        }
    }

    public static Object runnerAsyncReadEntry(ReadGraphImpl graph, final AsyncRead<?> r, final CacheEntry parent, final ListenerBase listener, final AsyncProcedure procedure, final boolean needsToBlock) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            return AsyncReadEntry.computeForEach(graph, r, null, procedure, needsToBlock);
        }
        AsyncReadEntry entry = cache.getOrCreateAsyncReadEntry(graph, r, needsToBlock);
        if (entry == null) {
            graph.processor.schedule(new QueryProcessor.SessionTask(graph){

                @Override
                public void run0(int thread) {
                    try {
                        QueryCache.runnerAsyncReadEntry(this.graph, r, parent, listener, procedure, needsToBlock);
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            });
            return null;
        }
        AsyncProcedure procedure_ = procedure != null ? procedure : emptyProcedureAsyncReadEntry;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            return entry.performFromCache(graph, procedure_);
        }
        assert (entry.isPending());
        Object result = AsyncReadEntry.computeForEach(graph, r, entry, procedure_, needsToBlock);
        if (listenerEntry != null) {
            cache.primeListenerEntry(listenerEntry, entry.getResult());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncReadEntry peekAsyncReadEntry(AsyncRead<?> r) {
        StableHashMap stableHashMap = this.asyncReadEntryMap;
        synchronized (stableHashMap) {
            return (AsyncReadEntry)this.asyncReadEntryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Types getOrCreateTypes(ReadGraphImpl graph, int r) throws DatabaseException {
        Types existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.typesMap;
        synchronized (unaryQueryHashMap) {
            existing = (Types)this.typesMap.get(r);
            if (existing == null) {
                existing = new Types(r);
                existing.setPending(this.querySupport);
                this.typesMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Types entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.typesMap;
        synchronized (unaryQueryHashMap) {
            this.typesMap.remove(entry.id);
        }
    }

    public static void runnerTypes(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            Types.computeForEach(graph, r, null, procedure);
            return;
        }
        Types entry = cache.getOrCreateTypes(graph, r);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedureTypes;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            Types.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Types peekTypes(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.typesMap;
        synchronized (unaryQueryHashMap) {
            return (Types)this.typesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChildMap getOrCreateChildMap(ReadGraphImpl graph, int r) throws DatabaseException {
        ChildMap existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.childMapMap;
        synchronized (unaryQueryHashMap) {
            existing = (ChildMap)this.childMapMap.get(r);
            if (existing == null) {
                existing = new ChildMap(r);
                existing.setPending(this.querySupport);
                this.childMapMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ChildMap entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.childMapMap;
        synchronized (unaryQueryHashMap) {
            this.childMapMap.remove(entry.id);
        }
    }

    public static void runnerChildMap(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<ObjectResourceIdMap<String>> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            ChildMap.computeForEach(graph, r, null, procedure);
            return;
        }
        ChildMap entry = cache.getOrCreateChildMap(graph, r);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedureChildMap;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            ChildMap.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChildMap peekChildMap(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.childMapMap;
        synchronized (unaryQueryHashMap) {
            return (ChildMap)this.childMapMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeHierarchy getOrCreateTypeHierarchy(ReadGraphImpl graph, int r) throws DatabaseException {
        TypeHierarchy existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.typeHierarchyMap;
        synchronized (unaryQueryHashMap) {
            existing = (TypeHierarchy)this.typeHierarchyMap.get(r);
            if (existing == null) {
                existing = new TypeHierarchy(r);
                existing.setPending(this.querySupport);
                this.typeHierarchyMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TypeHierarchy entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.typeHierarchyMap;
        synchronized (unaryQueryHashMap) {
            this.typeHierarchyMap.remove(entry.id);
        }
    }

    public static void runnerTypeHierarchy(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            TypeHierarchy.computeForEach(graph, r, null, procedure);
            return;
        }
        TypeHierarchy entry = cache.getOrCreateTypeHierarchy(graph, r);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedureTypeHierarchy;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            TypeHierarchy.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeHierarchy peekTypeHierarchy(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.typeHierarchyMap;
        synchronized (unaryQueryHashMap) {
            return (TypeHierarchy)this.typeHierarchyMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SuperTypes getOrCreateSuperTypes(ReadGraphImpl graph, int r) throws DatabaseException {
        SuperTypes existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.superTypesMap;
        synchronized (unaryQueryHashMap) {
            existing = (SuperTypes)this.superTypesMap.get(r);
            if (existing == null) {
                existing = new SuperTypes(r);
                existing.setPending(this.querySupport);
                this.superTypesMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(SuperTypes entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.superTypesMap;
        synchronized (unaryQueryHashMap) {
            this.superTypesMap.remove(entry.id);
        }
    }

    public static void runnerSuperTypes(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            SuperTypes.computeForEach(graph, r, null, procedure);
            return;
        }
        SuperTypes entry = cache.getOrCreateSuperTypes(graph, r);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedureSuperTypes;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            SuperTypes.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SuperTypes peekSuperTypes(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.superTypesMap;
        synchronized (unaryQueryHashMap) {
            return (SuperTypes)this.superTypesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SuperRelations getOrCreateSuperRelations(ReadGraphImpl graph, int r) throws DatabaseException {
        SuperRelations existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.superRelationsMap;
        synchronized (unaryQueryHashMap) {
            existing = (SuperRelations)this.superRelationsMap.get(r);
            if (existing == null) {
                existing = new SuperRelations(r);
                existing.setPending(this.querySupport);
                this.superRelationsMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(SuperRelations entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.superRelationsMap;
        synchronized (unaryQueryHashMap) {
            this.superRelationsMap.remove(entry.id);
        }
    }

    public static void runnerSuperRelations(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph.processor, r)) {
            SuperRelations.computeForEach(graph, r, null, procedure);
            return;
        }
        SuperRelations entry = cache.getOrCreateSuperRelations(graph, r);
        InternalProcedure procedure_ = procedure != null ? procedure : emptyProcedureSuperRelations;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            SuperRelations.computeForEach(graph, r, entry, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SuperRelations peekSuperRelations(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.superRelationsMap;
        synchronized (unaryQueryHashMap) {
            return (SuperRelations)this.superRelationsMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AssertedPredicates getOrCreateAssertedPredicates(ReadGraphImpl graph, int r) throws DatabaseException {
        AssertedPredicates existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.assertedPredicatesMap;
        synchronized (unaryQueryHashMap) {
            existing = (AssertedPredicates)this.assertedPredicatesMap.get(r);
            if (existing == null) {
                existing = new AssertedPredicates(r);
                existing.setPending(this.querySupport);
                this.assertedPredicatesMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(AssertedPredicates entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.assertedPredicatesMap;
        synchronized (unaryQueryHashMap) {
            this.assertedPredicatesMap.remove(entry.id);
        }
    }

    public static void runnerAssertedPredicates(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        AssertedPredicates entry = cache.getOrCreateAssertedPredicates(graph, r);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureAssertedPredicates;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            entry.compute(graph, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssertedPredicates peekAssertedPredicates(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.assertedPredicatesMap;
        synchronized (unaryQueryHashMap) {
            return (AssertedPredicates)this.assertedPredicatesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AssertedStatements getOrCreateAssertedStatements(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        AssertedStatements existing = null;
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.assertedStatementsMap;
        synchronized (doubleKeyQueryHashMap) {
            existing = (AssertedStatements)this.assertedStatementsMap.get(r1, r2);
            if (existing == null) {
                existing = new AssertedStatements(r1, r2);
                existing.setPending(this.querySupport);
                this.assertedStatementsMap.put(QueryCache.keyR2(r1, r2), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(AssertedStatements entry) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.assertedStatementsMap;
        synchronized (doubleKeyQueryHashMap) {
            this.assertedStatementsMap.remove(entry.id);
        }
    }

    public static void runnerAssertedStatements(ReadGraphImpl graph, int r1, int r2, CacheEntry parent, ListenerBase listener, TripleIntProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        AssertedStatements entry = cache.getOrCreateAssertedStatements(graph, r1, r2);
        TripleIntProcedure procedure_ = procedure != null ? procedure : emptyProcedureAssertedStatements;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            entry.compute(graph, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssertedStatements peekAssertedStatements(int r1, int r2) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = this.assertedStatementsMap;
        synchronized (doubleKeyQueryHashMap) {
            return (AssertedStatements)this.assertedStatementsMap.get(r1, r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectSuperRelations getOrCreateDirectSuperRelations(ReadGraphImpl graph, int r) throws DatabaseException {
        DirectSuperRelations existing = null;
        UnaryQueryHashMap unaryQueryHashMap = this.directSuperRelationsMap;
        synchronized (unaryQueryHashMap) {
            existing = (DirectSuperRelations)this.directSuperRelationsMap.get(r);
            if (existing == null) {
                existing = new DirectSuperRelations(r);
                existing.setPending(this.querySupport);
                this.directSuperRelationsMap.put(QueryCache.keyR(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectSuperRelations entry) {
        UnaryQueryHashMap unaryQueryHashMap = this.directSuperRelationsMap;
        synchronized (unaryQueryHashMap) {
            this.directSuperRelationsMap.remove(entry.id);
        }
    }

    public static void runnerDirectSuperRelations(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        DirectSuperRelations entry = cache.getOrCreateDirectSuperRelations(graph, r);
        IntProcedure procedure_ = procedure != null ? procedure : emptyProcedureDirectSuperRelations;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            entry.compute(graph, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectSuperRelations peekDirectSuperRelations(int r) {
        UnaryQueryHashMap unaryQueryHashMap = this.directSuperRelationsMap;
        synchronized (unaryQueryHashMap) {
            return (DirectSuperRelations)this.directSuperRelationsMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiReadEntry getOrCreateMultiReadEntry(ReadGraphImpl graph, MultiRead<?> r) throws DatabaseException {
        MultiReadEntry existing = null;
        StableHashMap stableHashMap = this.multiReadEntryMap;
        synchronized (stableHashMap) {
            existing = (MultiReadEntry)this.multiReadEntryMap.get(r);
            if (existing == null) {
                existing = new MultiReadEntry(r);
                existing.setPending(this.querySupport);
                this.multiReadEntryMap.put(QueryCache.id(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(MultiReadEntry entry) {
        StableHashMap stableHashMap = this.multiReadEntryMap;
        synchronized (stableHashMap) {
            this.multiReadEntryMap.remove(entry.id);
        }
    }

    public static void runnerMultiReadEntry(ReadGraphImpl graph, MultiRead<?> r, CacheEntry parent, ListenerBase listener, SyncMultiProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        MultiReadEntry entry = cache.getOrCreateMultiReadEntry(graph, r);
        SyncMultiProcedure procedure_ = procedure != null ? procedure : emptyProcedureMultiReadEntry;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            entry.compute(graph, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiReadEntry peekMultiReadEntry(MultiRead<?> r) {
        StableHashMap stableHashMap = this.multiReadEntryMap;
        synchronized (stableHashMap) {
            return (MultiReadEntry)this.multiReadEntryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncMultiReadEntry getOrCreateAsyncMultiReadEntry(ReadGraphImpl graph, AsyncMultiRead<?> r) throws DatabaseException {
        AsyncMultiReadEntry existing = null;
        StableHashMap stableHashMap = this.asyncMultiReadEntryMap;
        synchronized (stableHashMap) {
            existing = (AsyncMultiReadEntry)this.asyncMultiReadEntryMap.get(r);
            if (existing == null) {
                existing = new AsyncMultiReadEntry(r);
                existing.setPending(this.querySupport);
                this.asyncMultiReadEntryMap.put(QueryCache.id(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(AsyncMultiReadEntry entry) {
        StableHashMap stableHashMap = this.asyncMultiReadEntryMap;
        synchronized (stableHashMap) {
            this.asyncMultiReadEntryMap.remove(entry.id);
        }
    }

    public static void runnerAsyncMultiReadEntry(ReadGraphImpl graph, AsyncMultiRead<?> r, CacheEntry parent, ListenerBase listener, AsyncMultiProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        AsyncMultiReadEntry entry = cache.getOrCreateAsyncMultiReadEntry(graph, r);
        AsyncMultiProcedure procedure_ = procedure != null ? procedure : emptyProcedureAsyncMultiReadEntry;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            entry.compute(graph, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncMultiReadEntry peekAsyncMultiReadEntry(AsyncMultiRead<?> r) {
        StableHashMap stableHashMap = this.asyncMultiReadEntryMap;
        synchronized (stableHashMap) {
            return (AsyncMultiReadEntry)this.asyncMultiReadEntryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExternalReadEntry getOrCreateExternalReadEntry(ReadGraphImpl graph, ExternalRead<?> r) throws DatabaseException {
        ExternalReadEntry existing = null;
        StableHashMap stableHashMap = this.externalReadEntryMap;
        synchronized (stableHashMap) {
            existing = (ExternalReadEntry)this.externalReadEntryMap.get(r);
            if (existing == null) {
                existing = new ExternalReadEntry(r, graph);
                existing.setPending(this.querySupport);
                this.externalReadEntryMap.put(QueryCache.id(r), existing);
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ExternalReadEntry entry) {
        StableHashMap stableHashMap = this.externalReadEntryMap;
        synchronized (stableHashMap) {
            this.externalReadEntryMap.remove(entry.id);
        }
    }

    public static void runnerExternalReadEntry(ReadGraphImpl graph, ExternalRead<?> r, CacheEntry parent, ListenerBase listener, AsyncProcedure procedure) throws DatabaseException {
        QueryCache cache = graph.processor.cache;
        ExternalReadEntry entry = cache.getOrCreateExternalReadEntry(graph, r);
        AsyncProcedure procedure_ = procedure != null ? procedure : emptyProcedureExternalReadEntry;
        ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);
        if (entry.isReady()) {
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            entry.compute(graph, procedure_);
            if (listenerEntry != null) {
                cache.primeListenerEntry(listenerEntry, entry.getResult());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalReadEntry peekExternalReadEntry(ExternalRead<?> r) {
        StableHashMap stableHashMap = this.externalReadEntryMap;
        synchronized (stableHashMap) {
            return (ExternalReadEntry)this.externalReadEntryMap.get(r);
        }
    }
}

