/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;

import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.exception.NoDataSourceException;

/**
 * 
 */
public interface PrimitiveQueryUpdater {

    /**
     * A unique object representing a certain exploring context. This must be
     * different for separate graph explorer instances.
     * 
     * @return an object representing the current exploring context
     */
    Object getExplorerContext();

    /**
     * @param <T>
     * @param clazz
     * @return <code>null</code> if no data source is available
     */
    <T> DataSource<T> tryGetDataSource(Class<T> clazz);

    /**
     * @param <T>
     * @param clazz
     * @return a data source of the requested type.
     * @throws NoDataSourceException if data source was not found
     */
    <T> DataSource<T> getDataSource(Class<T> clazz) throws NoDataSourceException;

    /**
     * @param <T>
     * @param context
     * @param key
     * @param newResult
     */
    <T> void scheduleReplace(NodeContext context, PrimitiveQueryKey<T> key, T newResult);
    // <T> void scheduleClear(INodeContext context, PrimitiveQueryKey<T> key);

    /**
     * Tells whether this primitive query updater is disposed or not. Don't use
     * the updater after it is disposed. Disposal always happens in the UI
     * thread.
     * 
     * @return <code>true</code> if disposed
     */
    boolean isDisposed();
    boolean isShown(NodeContext context);
    
    void incRef(NodeContext context);
    void decRef(NodeContext context);

}