/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;

import org.simantics.browsing.ui.NodeContext.QueryKey;

public interface NodeQueryProcessor<T> {
    /**
     * @return the key that represents the query that this processor can respond
     *         to.
     */
    QueryKey<T> getIdentifier();

    /**
     * @param manager
     * @param context
     * @return the result of the query
     */
    T query(NodeQueryManager manager, NodeContext context);
}
