/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.test;

import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.BijectionMap;

public class GraphChanges {
    private Resource r1;
    private Resource r2;
    private List<Statement> deletions;
    private List<Statement> additions;
    private List<Modification> modifications;
    private BijectionMap<Resource, Resource> comparable;

    public GraphChanges(Resource r1, Resource r2, List<Statement> deletions, List<Statement> additions, List<Modification> modifications, BijectionMap<Resource, Resource> comparable) {
        this.r1 = r1;
        this.r2 = r2;
        this.deletions = deletions;
        this.additions = additions;
        this.modifications = modifications;
        this.comparable = comparable;
    }

    public Resource getResource1() {
        return this.r1;
    }

    public Resource getResource2() {
        return this.r2;
    }

    public List<Statement> getAdditions() {
        return this.additions;
    }

    public List<Statement> getDeletions() {
        return this.deletions;
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public BijectionMap<Resource, Resource> getComparable() {
        return this.comparable;
    }

    public String toString(ReadGraph graph) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        sb.append("Del:\n");
        for (Statement stm : this.deletions) {
            sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getSubject())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject()) + " (" + stm.getSubject() + " " + stm.getPredicate() + " " + stm.getObject() + ")\n");
        }
        sb.append("Add:\n");
        for (Statement stm : this.additions) {
            sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getSubject())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject()) + " (" + stm.getSubject() + " " + stm.getPredicate() + " " + stm.getObject() + ")\n");
        }
        sb.append("Mod:\n");
        for (Modification mod : this.modifications) {
            Statement stm = mod.getLeftStm();
            sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)mod.getLeftSub())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject()) + " (" + stm.getSubject() + " " + stm.getPredicate() + " " + stm.getObject() + ")\n");
            stm = mod.getRightStm();
            sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)mod.getRightSub())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject()) + " (" + stm.getSubject() + " " + stm.getPredicate() + " " + stm.getObject() + ")\n");
        }
        return sb.toString();
    }

    public String comparableToString(ReadGraph graph) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        sb.append("Comparable:\n");
        for (Map.Entry entry : this.comparable.getEntries()) {
            sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)entry.getKey()))) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)entry.getValue())) + " (" + entry.getKey() + " " + entry.getValue() + ")\n");
        }
        return sb.toString();
    }

    public static class Modification {
        Resource leftSub;
        Resource rightSub;
        Statement leftStm;
        Statement rightStm;
        int hashCode;

        public Modification(Resource leftSub, Resource rightSub, Statement leftStm, Statement rightStm) {
            this.leftSub = leftSub;
            this.rightSub = rightSub;
            this.leftStm = leftStm;
            this.rightStm = rightStm;
            this.hashCode = leftSub.hashCode() + rightSub.hashCode();
            if (leftStm != null) {
                this.hashCode += leftStm.hashCode();
            }
            if (rightStm != null) {
                this.hashCode += rightStm.hashCode();
            }
        }

        public boolean isLeftAsserted() {
            return !this.leftSub.equals(this.leftStm.getSubject());
        }

        public boolean isRightAsserted() {
            return !this.rightSub.equals(this.rightStm.getSubject());
        }

        public Resource getLeftSub() {
            return this.leftSub;
        }

        public void setLeftSub(Resource leftSub) {
            this.leftSub = leftSub;
        }

        public Resource getRightSub() {
            return this.rightSub;
        }

        public void setRightSub(Resource rightSub) {
            this.rightSub = rightSub;
        }

        public Statement getLeftStm() {
            return this.leftStm;
        }

        public void setLeftStm(Statement leftStm) {
            this.leftStm = leftStm;
        }

        public Statement getRightStm() {
            return this.rightStm;
        }

        public void setRightStm(Statement rightStm) {
            this.rightStm = rightStm;
        }

        public Resource getPredicate() {
            if (this.leftStm != null) {
                return this.leftStm.getPredicate();
            }
            return this.rightStm.getPredicate();
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Modification other = (Modification)obj;
            if (!this.leftSub.equals(other.leftSub)) {
                return false;
            }
            if (!this.rightSub.equals(other.rightSub)) {
                return false;
            }
            if (this.leftStm != null ? !this.leftStm.equals(other.leftStm) : other.leftStm != null) {
                return false;
            }
            return !(this.rightStm != null ? !this.rightStm.equals(other.rightStm) : other.rightStm != null);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

