/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.Resource;
import org.simantics.interop.mapping.data.Identifiable;
import org.simantics.interop.mapping.data.ResourceSetIdentifiable;
import org.simantics.interop.mapping.data.ResourceSplitIdentifiable;

public class ResourceSetSplitIdentifiable
extends ResourceSetIdentifiable {
    private static int counter = 0;
    private int identifier;
    private int index;

    ResourceSetSplitIdentifiable(Resource resource, int index, int identifier) {
        super(resource);
        this.index = index;
        this.identifier = identifier;
    }

    public ResourceSetSplitIdentifiable(int index, int identifier, Resource primary, Resource ... resource) {
        super(primary, resource);
        this.index = index;
        this.identifier = identifier;
    }

    public ResourceSetSplitIdentifiable(Resource primary, Collection<Resource> resources, int index, int identifier) {
        super(primary, resources);
        this.index = index;
        this.identifier = identifier;
    }

    public static List<Identifiable> createIdentifiables(ResourceSetIdentifiable identifiable, int count) {
        ArrayList<Identifiable> result = new ArrayList<Identifiable>(count);
        int identifier = counter++;
        int i = 0;
        while (i < count) {
            result.add(new ResourceSetSplitIdentifiable(identifiable.getPrimary(), identifiable.getResources(), i, identifier));
            ++i;
        }
        return result;
    }

    public static List<Identifiable> createIdentifiables(Identifiable identifiable, int count) {
        Resource res = identifiable.getAdapter(Resource.class);
        if (res == null) {
            return null;
        }
        Resource[] resources = identifiable.getAdapter(Resource[].class);
        if (resources.length > 1) {
            ArrayList<Identifiable> result = new ArrayList<Identifiable>(count);
            int identifier = counter++;
            int i = 0;
            while (i < count) {
                result.add(new ResourceSetSplitIdentifiable(i, identifier, res, resources));
                ++i;
            }
            return result;
        }
        return ResourceSplitIdentifiable.createIdentifiables(identifiable, count);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this.getClass() != arg0.getClass()) {
            return false;
        }
        ResourceSetSplitIdentifiable other = (ResourceSetSplitIdentifiable)arg0;
        if (this.identifier != other.identifier) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return super.equals(arg0);
    }

    @Override
    public Identifiable merge(Identifiable other) {
        throw new RuntimeException("Cannot be merged");
    }
}

