/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.mapping.GenerationRule;
import org.simantics.interop.mapping.MappingHints;
import org.simantics.interop.mapping.ModuleResolver;
import org.simantics.interop.mapping.data.GraphNode;
import org.simantics.interop.mapping.data.Identifiable;
import org.simantics.interop.mapping.data.Link;
import org.simantics.utils.datastructures.MapList;

public class MappingTools {
    public static Resource getSymbolType(ReadGraph g, GraphNode<Identifiable> node) throws DatabaseException {
        ModuleResolver resolver;
        Resource type = (Resource)node.getHint(MappingHints.KEY_GENERATE_TYPE);
        if (type == null && (resolver = (ModuleResolver)node.getHint(MappingHints.KEY_RESOLVER)) != null) {
            type = resolver.getSymbolType(g);
        }
        return type;
    }

    public static Resource getTerminal(ReadGraph g, Link<Identifiable> link) throws DatabaseException {
        ModuleResolver resolver;
        Resource terminal = (Resource)link.getHint(MappingHints.KEY_CONNECTION_TERMINAL);
        if (terminal == null && (resolver = (ModuleResolver)link.from().getHint(MappingHints.KEY_RESOLVER)) != null) {
            terminal = resolver.getTerminal(g, link);
        }
        return terminal;
    }

    public static void assignGenerationRule(GraphNode<Identifiable> node, int index, GenerationRule rule) {
        MapList rules = (MapList)node.getHint(MappingHints.KEY_GENERATION_RULES);
        if (rules == null) {
            rules = new MapList();
            node.setHint(MappingHints.KEY_GENERATION_RULES, rules);
        }
        rules.add((Object)index, (Object)rule);
    }

    public static void createEmptyGenerationRules(GraphNode<Identifiable> node) {
        node.setHint(MappingHints.KEY_GENERATION_RULES, new MapList());
    }

    public static void copyGenerationRules(GraphNode<Identifiable> from, GraphNode<Identifiable> to) {
        MapList rules = (MapList)from.getHint(MappingHints.KEY_GENERATION_RULES);
        if (rules == null) {
            return;
        }
        MapList toRules = (MapList)to.getHint(MappingHints.KEY_GENERATION_RULES);
        if (toRules == null) {
            toRules = new MapList();
            to.setHint(MappingHints.KEY_GENERATION_RULES, toRules);
        }
        for (Integer i : rules.getKeys()) {
            for (GenerationRule r : rules.getValues((Object)i)) {
                toRules.add((Object)i, (Object)r);
            }
        }
    }

    public static void copyHints(GraphNode<Identifiable> from, GraphNode<Identifiable> to) {
        to.setHints(from.getHints());
        MappingTools.createEmptyGenerationRules(to);
        MappingTools.copyGenerationRules(from, to);
        MappingTools.reconnectParent(from, to);
    }

    public static void copyDefaultHints(GraphNode<Identifiable> from, GraphNode<Identifiable> to) {
        to.setHints(from.getHints());
        MappingTools.createEmptyGenerationRules(to);
        MappingTools.reconnectParent(from, to);
    }

    private static void reconnectParent(GraphNode<Identifiable> from, GraphNode<Identifiable> to) {
        GraphNode parent = (GraphNode)((Object)from.getHint(MappingHints.KEY_PARENT_NODE));
        if (parent != null) {
            MappingTools.setParentNode(parent, to);
        }
    }

    public static <T> void disposeNodes(Collection<GraphNode<T>> nodes) {
        for (GraphNode<T> node : nodes) {
            node.destroy();
        }
        nodes.clear();
    }

    public static void setParentNode(GraphNode<?> parent, GraphNode<?> child) {
        child.setHint(MappingHints.KEY_PARENT_NODE, parent);
        ArrayList children = (ArrayList)parent.getHint(MappingHints.KEY_CHILD_NODE);
        if (children == null) {
            children = new ArrayList();
            parent.setHint(MappingHints.KEY_CHILD_NODE, children);
        }
        children.add(child);
    }

    public static void unsetParentNode(GraphNode<?> child) {
        GraphNode parent = (GraphNode)((Object)child.getHint(MappingHints.KEY_PARENT_NODE));
        if (parent == null) {
            return;
        }
        Collection children = (Collection)parent.getHint(MappingHints.KEY_CHILD_NODE);
        children.remove(child);
        child.removeHint(MappingHints.KEY_PARENT_NODE);
    }
}

