/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalCharObjMapOps;
import com.koloboke.collect.map.CharObjMap;
import com.koloboke.function.CharObjConsumer;
import com.koloboke.function.CharObjPredicate;
import java.util.Map;

public final class CommonCharObjMapOps {
    public static boolean containsAllEntries(final InternalCharObjMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof CharObjMap) {
            CharObjMap m2 = (CharObjMap)another;
            if (m2.valueEquivalence().equals((Object)map.valueEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalCharObjMapOps) {
                    return ((InternalCharObjMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new CharObjPredicate(){

                public boolean test(char a, Object b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Character)e.getKey()).charValue(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <V> void putAll(final InternalCharObjMapOps<V> map, Map<? extends Character, ? extends V> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof CharObjMap) {
            if (another instanceof InternalCharObjMapOps) {
                ((InternalCharObjMapOps)another).reversePutAllTo(map);
            } else {
                ((CharObjMap)another).forEach(new CharObjConsumer<V>(){

                    public void accept(char key, V value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<Character, V> e : another.entrySet()) {
                map.justPut(e.getKey().charValue(), e.getValue());
            }
        }
    }

    private CommonCharObjMapOps() {
    }
}

