/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui.parts;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Composite;
import org.simantics.district.selection.ElementSelector;
import org.simantics.district.selection.ui.ElementSelectorTableUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementSelectionView {
    private static final String CONTEXT_MENU_ID = "org.simantics.district.selection.ui.contextMenu";
    private static final String POPUP_ID = "org.simantics.district.selection.ui.selectiontable.popup";
    private static final String CREATE_NEW_ID = "org.simantics.district.selection.ui.command.createNewSelection";
    private static final String CREATE_NEW_LABEL = "Create New Element Selection Query";
    private static final String CREATE_NEW_ICON = "platform:/plugin/com.famfamfam.silk/icons/add.png";
    private static final String EDIT_ID = "org.simantics.district.selection.ui.command.editElementSelector";
    private static final String EDIT_LABEL = "Edit Element Selection Query";
    private static final String EDIT_ICON = "platform:/plugin/com.famfamfam.silk/icons/pencil.png";
    private static final String DELETE_ID = "org.simantics.district.selection.ui.command.deleteElementSelector";
    private static final String DELETE_LABEL = "Delete Element Selection Query";
    private static final String DELETE_ICON = "platform:/plugin/com.famfamfam.silk/icons/cross.png";
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementSelectionView.class);
    private ElementSelectorTableUI table;
    @Inject
    private ESelectionService selectionService;

    @Inject
    public void init(MPart part, MApplication app) {
        MHandledToolItem createItem = MMenuFactory.INSTANCE.createHandledToolItem();
        createItem.setCommand(app.getCommand(CREATE_NEW_ID));
        createItem.setLabel(CREATE_NEW_LABEL);
        createItem.setIconURI(CREATE_NEW_ICON);
        MHandledToolItem editItem = MMenuFactory.INSTANCE.createHandledToolItem();
        editItem.setCommand(app.getCommand(EDIT_ID));
        editItem.setLabel(EDIT_LABEL);
        editItem.setIconURI(EDIT_ICON);
        MHandledToolItem deleteItem = MMenuFactory.INSTANCE.createHandledToolItem();
        deleteItem.setCommand(app.getCommand(DELETE_ID));
        deleteItem.setLabel(DELETE_LABEL);
        deleteItem.setIconURI(DELETE_ICON);
        MToolBar toolBar = MMenuFactory.INSTANCE.createToolBar();
        toolBar.setToBeRendered(true);
        List children = toolBar.getChildren();
        children.add(createItem);
        children.add(editItem);
        children.add(deleteItem);
        part.setToolbar(toolBar);
        MPopupMenu popupMenu = MMenuFactory.INSTANCE.createPopupMenu();
        popupMenu.setElementId(POPUP_ID);
        List menuContributions = app.getMenuContributions();
        for (MMenuContribution menuContribution : menuContributions) {
            if (!CONTEXT_MENU_ID.equals(menuContribution.getParentId())) continue;
            popupMenu.getChildren().addAll(menuContribution.getChildren());
        }
        part.getMenus().add(popupMenu);
    }

    @PostConstruct
    public void createPartControl(Composite parent, EMenuService menuService) {
        this.table = new ElementSelectorTableUI(this.selectionService, parent, 2048);
        if (!menuService.registerContextMenu((Object)this.table.getTree(), POPUP_ID)) {
            LOGGER.warn("Could not register context menu {}", (Object)POPUP_ID);
        }
    }

    @Focus
    public void setFocus() {
        this.table.setFocus();
    }

    public ElementSelector getSelectedItem() {
        return this.table.getSelectedItem();
    }
}

