/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.SyncListenerAdapter;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.district.network.ui.DistrictNetworkUIUtil;
import org.simantics.district.selection.ElementSelectionResource;
import org.simantics.district.selection.ElementSelector;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.Lists;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementSelectorTableUI
extends Composite {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementSelectorTableUI.class);
    private TreeViewer viewer;
    private TreeViewerColumn column1;
    private TreeViewerColumn column2;

    public ElementSelectorTableUI(ESelectionService selectionService, final Composite parent, int style) {
        super(parent, style);
        parent.setLayout((Layout)new FillLayout());
        this.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer((Composite)this, 65536);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(selectionService));
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null || !(inputElement instanceof Collection)) {
                    return new Object[0];
                }
                return ((Collection)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                super.inputChanged(viewer, oldInput, newInput);
            }
        });
        Simantics.getSession().asyncRequest((Read)new SelectionsRequest(), (SyncListener)new SyncListenerAdapter<Collection<ElementSelector>>(){

            public void execute(ReadGraph graph, Collection<ElementSelector> result) {
                parent.getDisplay().asyncExec(() -> ElementSelectorTableUI.this.viewer.setInput((Object)result));
            }

            public void exception(ReadGraph graph, Throwable t) throws DatabaseException {
                LOGGER.error("Error getting element selector list", t);
            }

            public boolean isDisposed() {
                return ElementSelectorTableUI.this.isDisposed();
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        Tree table = this.viewer.getTree();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.column1 = new TreeViewerColumn(this.viewer, 0);
        this.column1.getColumn().setText("Name");
        this.column1.getColumn().setWidth(200);
        this.column1.getColumn().setResizable(true);
        this.column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ElementSelector selector = (ElementSelector)element;
                return selector.getName();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.column2 = new TreeViewerColumn(this.viewer, 0);
        this.column2.getColumn().setText("Query");
        this.column2.getColumn().setWidth(600);
        this.column2.getColumn().setResizable(true);
        this.column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ElementSelector selector = (ElementSelector)element;
                return selector.getExpression();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
    }

    public Tree getTree() {
        return this.viewer.getTree();
    }

    public ElementSelector getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection != null ? (ElementSelector)selection.getFirstElement() : null;
    }

    private static final class DoubleClickListener
    implements IDoubleClickListener {
        private final ESelectionService selectionService;
        private Resource model;

        private DoubleClickListener(ESelectionService selectionService) {
            this.selectionService = selectionService;
        }

        public void doubleClick(DoubleClickEvent event) {
            TreeSelection selection = (TreeSelection)event.getViewer().getSelection();
            final ElementSelector query = (ElementSelector)selection.getFirstElement();
            try {
                List result = (List)Simantics.getSession().syncRequest((Read)new Read<List<Resource>>(){

                    public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                        model = ActiveModels.getPossibleActiveModel((ReadGraph)graph, (Resource)Simantics.getProjectResource());
                        if (model == null) {
                            LOGGER.warn("No active model");
                            return Collections.emptyList();
                        }
                        return query.selectElementsFrom(graph, model);
                    }
                });
                if (query.getGenerator() instanceof ElementSelector.DiagramGenerator || query.getGenerator() instanceof ElementSelector.ExplicitGenerator) {
                    DistrictNetworkUIUtil.openDNDiagramWithSelection((Display)event.getViewer().getControl().getDisplay(), (List)result);
                } else {
                    this.selectionService.setPostSelection((Object)new StructuredSelection(Lists.map((Function)new FunctionImpl1<Resource, AdaptableHintContext>(){

                        public AdaptableHintContext apply(Resource p0) {
                            SelectionElement selectionElement = new SelectionElement(SelectionHints.STD_KEYS);
                            selectionElement.setHint(SelectionHints.KEY_MAIN, p0);
                            selectionElement.setHint(SelectionHints.KEY_MODEL, model);
                            return selectionElement;
                        }
                    }, (List)result)));
                }
            }
            catch (DatabaseException e) {
                LOGGER.error("Element selection query failed", (Throwable)e);
            }
        }
    }

    private static final class SelectionElement
    extends AdaptableHintContext {
        private SelectionElement(IHintContext.Key[] keys) {
            super(keys);
        }

        public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
            Resource element = (Resource)this.getHint(SelectionHints.KEY_MAIN);
            if (contentType instanceof AnyResource) {
                return (T)element;
            }
            if (contentType instanceof AnyVariable) {
                try {
                    return (T)Simantics.getSession().syncRequest((Read)new ResourceRead<Variable>(element){

                        public Variable perform(ReadGraph graph) throws DatabaseException {
                            return ElementSelector.getVariableForElement((ReadGraph)graph, (Resource)this.resource);
                        }
                    });
                }
                catch (DatabaseException databaseException) {
                    return null;
                }
            }
            return null;
        }
    }

    public static final class SelectionsRequest
    implements Read<Collection<ElementSelector>> {
        public Collection<ElementSelector> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
            Resource model = ActiveModels.getPossibleActiveModel((ReadGraph)graph, (Resource)Simantics.getProjectResource());
            if (model == null) {
                return Collections.emptyList();
            }
            List libs = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)ES.SelectionLibrary);
            if (libs.isEmpty()) {
                return Collections.emptyList();
            }
            Resource lib = (Resource)libs.get(0);
            ArrayList<ElementSelector> result = new ArrayList<ElementSelector>();
            for (Resource selection : graph.getObjects(lib, L0.ConsistsOf)) {
                if (!graph.isInstanceOf(selection, ES.Selection)) continue;
                result.add(ElementSelector.getSelector((RequestProcessor)graph, (Resource)selection));
            }
            return result;
        }
    }
}

