package org.simantics.workbench.internal.dialogs;

import java.io.IOException;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.workbench.internal.Activator;
import org.simantics.workbench.internal.Messages;
import org.simantics.workbench.internal.preferences.SimanticsPreferences;

/**
 * Generic workbench main preference page.
 */
public class SimanticsPreferencePage extends PreferencePage implements
IWorkbenchPreferencePage {

    private Button showDatabaseControlsButton;

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.preference.PreferencePage
     */
    protected Control createContents(Composite parent) {

        Composite composite = createComposite(parent);

        createButtons(composite);

        createSpace(composite);

        applyDialogFont(composite);

        return composite;
    }

    /**
     * Create the buttons at the top of the preference page.
     * @param composite
     */
    protected void createButtons(Composite composite) {
        createDatabaseControlPref(composite);
    }

    /**
     * Create the widget for the heap status preference.
     * 
     * @param composite
     */
    protected void createDatabaseControlPref(Composite composite) {
        showDatabaseControlsButton = new Button(composite, SWT.CHECK);
        showDatabaseControlsButton.setText(Messages.SimanticsPreferencePage_ShowDatabaseControlsButton);
        showDatabaseControlsButton.setToolTipText(Messages.SimanticsPreferencePage_ShowDatabaseControlsTooltip);
        showDatabaseControlsButton.setSelection(getPreferenceStore().getBoolean(SimanticsPreferences.SHOW_DATABASE_CONTROLS));
    }

    /**
     * Creates the composite which will contain all the preference controls for
     * this page.
     * 
     * @param parent
     *            the parent composite
     * @return the composite for this page
     */
    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout(layout);
        composite.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
        return composite;
    }

    /**
     * Utility method that creates a radio button instance and sets the default
     * layout data.
     * 
     * @param parent
     *            the parent for the new button
     * @param label
     *            the label for the new button
     * @return the newly-created button
     */
    protected static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, SWT.RADIO | SWT.LEFT);
        button.setText(label);
        return button;
    }

    /**
     * Utility method that creates a combo box
     * 
     * @param parent
     *            the parent for the new label
     * @return the new widget
     */
    protected static Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, SWT.READ_ONLY);
        GridData data = new GridData(GridData.FILL_HORIZONTAL);
        data.widthHint = IDialogConstants.ENTRY_FIELD_WIDTH;
        combo.setLayoutData(data);
        return combo;
    }

    /**
     * Creates a tab of one horizontal spans.
     * 
     * @param parent
     *            the parent in which the tab should be created
     */
    protected static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.BEGINNING;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = GridData.CENTER;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData(gridData);
    }

    /**
     * Returns preference store that belongs to the our plugin.
     * 
     * @return the preference store for this plugin
     */
    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    /**
     * @see IWorkbenchPreferencePage
     */
    public void init(IWorkbench aWorkbench) {
    }

    /**
     * The default button has been pressed.
     */
    protected void performDefaults() {
        IPreferenceStore store = getPreferenceStore();
        boolean showDatabaseControls = store.getDefaultBoolean(SimanticsPreferences.SHOW_DATABASE_CONTROLS);
        showDatabaseControlsButton.setSelection(showDatabaseControls);
        super.performDefaults();
    }

    /**
     * The user has pressed Ok. Store/apply this page's values appropriately.
     */
    public boolean performOk() {
        IPreferenceStore store = getPreferenceStore();
        store.setValue(SimanticsPreferences.SHOW_DATABASE_CONTROLS, showDatabaseControlsButton.getSelection());
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore) store).save();
            } catch (IOException e) {
                ErrorLogger.defaultLogError(e);
            }
        }
        return true;
    }

}
