/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import java.text.MessageFormat;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class STSCounterPanel
extends Composite {
    protected Text numberOfErrors;
    protected Text numberOfSkipped;
    protected Text numberOfFailures;
    protected Text numberOfRuns;
    protected int total;
    protected int ignoredCount;
    protected int assumptionFailedCount;
    private final Image fErrorIcon = null;
    private final Image fFailureIcon = null;

    public STSCounterPanel(Composite parent) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.numberOfRuns = this.createLabel("Runs:", null, " 0/0  ");
        this.numberOfSkipped = this.createLabel("Skipped:", null, " 0 ");
        this.numberOfErrors = this.createLabel("Errors:", this.fErrorIcon, " 0 ");
        this.numberOfFailures = this.createLabel("Failures:", this.fFailureIcon, " 0 ");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                STSCounterPanel.this.disposeIcons();
            }
        });
    }

    private void disposeIcons() {
        if (this.fErrorIcon != null) {
            this.fErrorIcon.dispose();
        }
        if (this.fFailureIcon != null) {
            this.fFailureIcon.dispose();
        }
    }

    private Text createLabel(String name, Image image, String init) {
        Label label = new Label((Composite)this, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label((Composite)this, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(32));
        Text value = new Text((Composite)this, 8);
        value.setText(init);
        value.setLayoutData((Object)new GridData(800));
        return value;
    }

    public void reset() {
        this.setErrorValue(0);
        this.setFailureValue(0);
        this.setRunValue(0, 0, 0);
        this.total = 0;
    }

    public void setTotal(int value) {
        this.total = value;
    }

    public int getTotal() {
        return this.total;
    }

    public void setRunValue(int value, int ignoredCount, int assumptionFailureCount) {
        String runStringTooltip;
        String runString;
        if (ignoredCount == 0 && assumptionFailureCount == 0) {
            runStringTooltip = runString = Messages.format("{0}/{1}", new String[]{Integer.toString(value), Integer.toString(this.total)});
        } else if (ignoredCount != 0 && assumptionFailureCount == 0) {
            runString = Messages.format("Skipped", new String[]{Integer.toString(value), Integer.toString(this.total), Integer.toString(ignoredCount)});
            runStringTooltip = Messages.format("Ignored", new String[]{Integer.toString(value), Integer.toString(this.total), Integer.toString(ignoredCount)});
        } else if (ignoredCount == 0 && assumptionFailureCount != 0) {
            runString = Messages.format("Skipped", new String[]{Integer.toString(value), Integer.toString(this.total), Integer.toString(assumptionFailureCount)});
            runStringTooltip = Messages.format("Failed", new String[]{Integer.toString(value), Integer.toString(this.total), Integer.toString(assumptionFailureCount)});
        } else {
            runString = Messages.format("Skipped", new String[]{Integer.toString(value), Integer.toString(this.total), Integer.toString(ignoredCount + assumptionFailureCount)});
            runStringTooltip = Messages.format("Failed", new String[]{Integer.toString(value), Integer.toString(this.total), Integer.toString(ignoredCount), Integer.toString(assumptionFailureCount)});
        }
        this.numberOfRuns.setText(runString);
        this.numberOfRuns.setToolTipText(runStringTooltip);
        if (ignoredCount == 0 && ignoredCount > 0 || ignoredCount != 0 && ignoredCount == 0) {
            this.layout();
        } else if (this.assumptionFailedCount == 0 && assumptionFailureCount > 0 || this.assumptionFailedCount != 0 && assumptionFailureCount == 0) {
            this.layout();
        } else {
            this.numberOfRuns.redraw();
            this.redraw();
        }
        this.assumptionFailedCount = assumptionFailureCount;
    }

    public void setIgnoredValue(int value) {
        this.numberOfSkipped.setText(Integer.toString(value));
        this.redraw();
    }

    public void setErrorValue(int value) {
        this.numberOfErrors.setText(Integer.toString(value));
        this.redraw();
    }

    public void setFailureValue(int value) {
        this.numberOfFailures.setText(Integer.toString(value));
        this.redraw();
    }

    private static class Messages {
        public static String format(String message, Object object) {
            return MessageFormat.format(message, object);
        }

        public static String format(String message, Object[] objects) {
            return MessageFormat.format(message, objects);
        }

        private Messages() {
        }
    }
}

