/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.simulator.variable;

/**
 * Realm controls access to some local resource.
 * 
 * @author Hannu Niemist&ouml;
 * @author Antti Villberg
 */
public interface Realm {

    /**
     * Executes the given runnable in this realm synchronously so that the method
     * returns only after the runnable has finished. Can be called only when not 
     * inside the realm. Calling the method in the realm either causes 
     * a deadlock or {@link IllegalStateException}. 
     * @throws InterruptedException 
     */
	void syncExec(Runnable runnable) throws InterruptedException;
	
    /**
     * Executes the runnable in this realm asynchronously.
     * This method can be called freely inside or outside of the realm. 
     * When executed inside the realm it is guaranteed that no 
     * internal event (for example a simulator step) is taken before
     * executing the runnable.
     */
	void asyncExec(Runnable runnable);
	
}
