package org.simantics.scl.commands.internal;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.scl.commands.Command;

public class ErrorCommand implements Command {

    String name;
    
    public ErrorCommand(String name) {
        this.name = name;
    }

    @Override
    public Object execute(RequestProcessor processor, Resource model, Object... parameters) throws DatabaseException {
        throw new DatabaseException("Command " + name + " is not available.");
    }

    @Override
    public boolean check(RequestProcessor processor, Resource model,
            Object... parameters) throws DatabaseException {
        return false;
    }

    @Override
    public void asyncExecute(RequestProcessor processor, Resource model,
            Object[] parameters, Procedure<Object> procedure) {
        procedure.exception(new DatabaseException("Command " + name + " is not available."));
    }

}
