package org.simantics.modeling.tests.commands;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.WriteCommand;

public class UnloadDiagram extends WriteCommand<CommandSequenceEnvironment> {

	private LoadDiagram diagram;
	
	public UnloadDiagram(LoadDiagram diagram) {
		this.diagram = diagram;
	}
	
	@Override
	public void run(CommandSequenceEnvironment environment) throws DatabaseException {
		
		diagram.getProvider().dispose();
		diagram.getContext().dispose();
		diagram.getActivation().deactivate();
		diagram.getWorkerThread().stopDispatchingEvents(true);
		
	}

}