/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.rule;

import gnu.trove.map.hash.TObjectIntHashMap;

import org.simantics.db.Resource;
import org.simantics.mapping.constraint.TooManyUnboundVariablesException;
import org.simantics.mapping.rule.instructions.AndRuleInstruction;
import org.simantics.mapping.rule.instructions.IRuleInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class AndRule implements IRule {

	IRule[] rules;	
	
	public AndRule(IRule ... rules) {
		this.rules = rules;
	}

	@Override
	public ImmutableSet<Resource> binds() {
		ImmutableSet<Resource> ret = ImmutableSet.empty();
		for(IRule rule : rules)
			ret = ret.addAll(rule.binds());
		return ret;
	}

	@Override
	public IRuleInstruction createInstruction(
			TObjectIntHashMap<Resource> variableIds, ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
		IRuleInstruction[] instructions = new IRuleInstruction[rules.length];
		for(int i=0;i<rules.length;++i)
			instructions[i] = rules[i].createInstruction(variableIds, bound);
		return new AndRuleInstruction(instructions);
	}

}
