/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.binaryPredicates;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Pair;

public class Relation extends BinaryPredicate {

	Resource relation;
	
	public Relation(Resource relation) {
		this.relation = relation;
	}

	@Override
	public Collection<Resource> getObjects(ReadGraph g, Resource subject) throws DatabaseException {
		return g.getObjects(subject, relation);
	}

	@Override
	public Collection<Pair<Resource, Resource>> getStatements(ReadGraph g) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Collection<Resource> getSubjects(ReadGraph g, Resource object) throws DatabaseException {
		return g.getObjects(object, g.getInverse(relation));
	}

	@Override
	public boolean has(ReadGraph g, Resource subject, Resource object) throws DatabaseException {
		return g.hasStatement(subject, relation, object);
	}

	@Override
	public boolean supportsGetObjects() {
		return true;
	}

	@Override
	public boolean supportsGetStatements() {
		return false;
	}

	@Override
	public boolean supportsGetSubjects() {
		return true;
	}

	@Override
	public void add(WriteGraph g, Resource subject, Resource object) throws DatabaseException {
		g.claim(subject, relation, object);
	}

	@Override
	public void remove(WriteGraph g, Resource subject, Resource object) throws DatabaseException {
		g.denyStatement(subject, relation, object);
	}

	@Override
	public boolean supportsAdditions() {
		return true;
	}

	@Override
	public boolean supportsRemovals() {
		return false;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((relation == null) ? 0 : relation.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Relation other = (Relation) obj;
		if (relation == null) {
			if (other.relation != null)
				return false;
		} else if (!relation.equals(other.relation))
			return false;
		return true;
	}
	
	@Override
	public IBinaryPredicate inverse(ReadGraph g) throws DatabaseException {
		return new Relation(g.getInverse(relation));
	}
	
	@Override
	public String toString(ReadGraph g) throws DatabaseException {
		return NameUtils.getSafeName(g, relation);
	}
	
}
