package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.List;

import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.Document.TextSize;
import org.simantics.document.linking.report.RowContentProvider;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TextItem;


public abstract class TableReportWriter<T> implements ReportWriter<T> {

	private List<RowContentProvider<T>> lineContentProviders = new ArrayList<RowContentProvider<T>>(); 
	private List<RowContentProvider<T>> cellContentProviders = new ArrayList<RowContentProvider<T>>(); 

	public void addLineProvider(RowContentProvider<T> provider) {
		lineContentProviders.add(provider);
	}

	public void addCellProvider(RowContentProvider<T> provider) {
		cellContentProviders.add(provider);
	}
	
	public void clearProviders() {
		lineContentProviders.clear();
		cellContentProviders.clear();
	}
	
	TextItem line[] = new TextItem[1];
	public void write(T previous, T current, T next, Document writer) throws Exception {
		
		
		for (RowContentProvider<T> cp : lineContentProviders) {
			line[0] = writer.newItem(TextItem.class);
			cp.setText(writer, previous, current, next,line);
			if (line[0].getText() != null && line[0].getText().length() > 0) {
				Table table = writer.getCurrentElement(Table.class);
				TextSize size = table.getTextSize();
				table.setTextSize(TextSize.MEDIUM);
				table.writeRowItem(line[0]);
				table.setTextSize(size);
			}
		}
		
		
		TextItem text[] = new TextItem[writer.getCurrentElement(Table.class).getColumns().size()];
		for (RowContentProvider<T> cp : cellContentProviders) {
			cp.setText(writer, previous, current, next,text);
		}
		
		for (int i = 0; i < text.length; i++) {
			if (text[i] != null) {
				writer.getCurrentElement(Table.class).writeRowItem(text);
				break;
			}
		}
		
	};
	
	
	
	
	
}
